/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.HostNameBasedUniqueTicketIdGenerator;
import org.apereo.cas.util.function.FunctionUtils;

public class OAuth20DefaultRefreshTokenFactory
implements OAuth20RefreshTokenFactory {
    protected final UniqueTicketIdGenerator refreshTokenIdGenerator;
    protected final TicketRegistry ticketRegistry;
    protected final ExpirationPolicyBuilder<OAuth20RefreshToken> expirationPolicyBuilder;
    protected final ServicesManager servicesManager;
    protected final TicketTrackingPolicy descendantTicketsTrackingPolicy;
    protected final CasConfigurationProperties casProperties;

    public OAuth20DefaultRefreshTokenFactory(ExpirationPolicyBuilder<OAuth20RefreshToken> expirationPolicyBuilder, TicketRegistry ticketRegistry, ServicesManager servicesManager, TicketTrackingPolicy descendantTicketsTrackingPolicy, CasConfigurationProperties casProperties) {
        this((UniqueTicketIdGenerator)new HostNameBasedUniqueTicketIdGenerator(), ticketRegistry, expirationPolicyBuilder, servicesManager, descendantTicketsTrackingPolicy, casProperties);
    }

    public OAuth20RefreshToken create(Service service, Authentication authentication, Ticket ticketGrantingTicket, Collection<String> scopes, String clientId, String accessToken, Map<String, Map<String, Object>> requestClaims, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) throws Throwable {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
        boolean limitReached = false;
        if (ticketGrantingTicket != null) {
            long maxNumberOfTokensAllowed = this.getMaxNumberOfRefreshTokensAllowed(registeredService);
            if (maxNumberOfTokensAllowed > 0L) {
                limitReached = this.descendantTicketsTrackingPolicy.countTicketsFor(ticketGrantingTicket, service) >= maxNumberOfTokensAllowed || this.ticketRegistry.countTicketsFor(service) >= maxNumberOfTokensAllowed;
            }
            FunctionUtils.throwIf((boolean)limitReached, () -> new IllegalArgumentException("Refresh token limit for %s is reached".formatted(service.getId())));
        }
        String codeId = this.refreshTokenIdGenerator.getNewTicketId("RT");
        ExpirationPolicy expirationPolicyToUse = this.determineExpirationPolicyForService((RegisteredService)registeredService);
        OAuth20DefaultRefreshToken refreshToken = new OAuth20DefaultRefreshToken(codeId, service, authentication, expirationPolicyToUse, ticketGrantingTicket, scopes, clientId, accessToken, requestClaims, responseType, grantType);
        this.descendantTicketsTrackingPolicy.trackTicket(ticketGrantingTicket, (Ticket)refreshToken);
        return refreshToken;
    }

    private long getMaxNumberOfRefreshTokensAllowed(OAuthRegisteredService registeredService) {
        return Optional.ofNullable(registeredService).map(OAuthRegisteredService::getRefreshTokenExpirationPolicy).map(RegisteredServiceOAuthRefreshTokenExpirationPolicy::getMaxActiveTokens).orElseGet(() -> this.casProperties.getAuthn().getOauth().getRefreshToken().getMaxActiveTokensAllowed());
    }

    protected ExpirationPolicy determineExpirationPolicyForService(RegisteredService registeredService) {
        return this.expirationPolicyBuilder.buildTicketExpirationPolicyFor((RegisteredServiceDefinition)registeredService);
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20RefreshToken.class;
    }

    @Generated
    public OAuth20DefaultRefreshTokenFactory(UniqueTicketIdGenerator refreshTokenIdGenerator, TicketRegistry ticketRegistry, ExpirationPolicyBuilder<OAuth20RefreshToken> expirationPolicyBuilder, ServicesManager servicesManager, TicketTrackingPolicy descendantTicketsTrackingPolicy, CasConfigurationProperties casProperties) {
        this.refreshTokenIdGenerator = refreshTokenIdGenerator;
        this.ticketRegistry = ticketRegistry;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.servicesManager = servicesManager;
        this.descendantTicketsTrackingPolicy = descendantTicketsTrackingPolicy;
        this.casProperties = casProperties;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20RefreshToken> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

