/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientAuthenticationMethods;
import org.apereo.cas.support.oauth.authenticator.OAuth20X509Authenticator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.pac4j.core.context.CallContext;

public class OidcX509Authenticator
extends OAuth20X509Authenticator {
    private final OidcServerDiscoverySettings oidcServerDiscoverySettings;

    public OidcX509Authenticator(ServicesManager servicesManager, OAuth20RequestParameterResolver requestParameterResolver, OidcServerDiscoverySettings oidcServerDiscoverySettings) {
        super(servicesManager, requestParameterResolver);
        this.oidcServerDiscoverySettings = oidcServerDiscoverySettings;
    }

    protected boolean isAuthenticationMethodSupported(CallContext ctx, OAuthRegisteredService registeredService) {
        boolean authMethodSupported = this.oidcServerDiscoverySettings.getTokenEndpointAuthMethodsSupported().stream().map(OAuth20ClientAuthenticationMethods::parse).anyMatch(method -> method == OAuth20ClientAuthenticationMethods.TLS_CLIENT_AUTH);
        return super.isAuthenticationMethodSupported(ctx, registeredService) && authMethodSupported;
    }
}

