/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation;

import java.io.StringReader;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.apereo.cas.client.authentication.AttributePrincipalImpl;
import org.apereo.cas.client.proxy.Cas20ProxyRetriever;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.proxy.ProxyRetriever;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.XmlUtils;
import org.apereo.cas.client.validation.AbstractCasProtocolUrlBasedTicketValidator;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.AssertionImpl;
import org.apereo.cas.client.validation.TicketValidationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Cas20ServiceTicketValidator
extends AbstractCasProtocolUrlBasedTicketValidator {
    public static final String PGT_ATTRIBUTE = "proxyGrantingTicket";
    private static final String PGTIOU_PREFIX = "PGTIOU-";
    private String proxyCallbackUrl;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage;
    private ProxyRetriever proxyRetriever;
    private PrivateKey privateKey;

    public Cas20ServiceTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
        this.proxyRetriever = new Cas20ProxyRetriever(casServerUrlPrefix, this.getEncoding(), this.getURLConnectionFactory());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
        urlParameters.put("pgtUrl", this.proxyCallbackUrl);
    }

    @Override
    protected String getUrlSuffix() {
        return "serviceValidate";
    }

    @Override
    protected Assertion parseResponseFromServer(String response) throws TicketValidationException {
        AssertionImpl assertion;
        String error = Cas20ServiceTicketValidator.parseAuthenticationFailureFromResponse(response);
        if (CommonUtils.isNotBlank(error)) {
            throw new TicketValidationException(error);
        }
        String principal = Cas20ServiceTicketValidator.parsePrincipalFromResponse(response);
        String proxyGrantingTicket = this.retrieveProxyGrantingTicket(response);
        if (CommonUtils.isEmpty(principal)) {
            throw new TicketValidationException("No principal was found in the response from the CAS server.");
        }
        Map<String, Object> attributes = this.extractCustomAttributes(response);
        if (CommonUtils.isNotBlank(proxyGrantingTicket)) {
            attributes.remove(PGT_ATTRIBUTE);
            AttributePrincipalImpl attributePrincipal = new AttributePrincipalImpl(principal, attributes, proxyGrantingTicket, this.proxyRetriever);
            assertion = new AssertionImpl(attributePrincipal);
        } else {
            assertion = new AssertionImpl(new AttributePrincipalImpl(principal, attributes));
        }
        this.customParseResponse(response, assertion);
        return assertion;
    }

    protected String retrieveProxyGrantingTicket(String response) {
        List<String> values = XmlUtils.getTextForElements(response, PGT_ATTRIBUTE);
        for (String value : values) {
            if (value == null) continue;
            if (value.startsWith(PGTIOU_PREFIX)) {
                return this.retrieveProxyGrantingTicketFromStorage(value);
            }
            return this.retrieveProxyGrantingTicketViaEncryption(value);
        }
        return null;
    }

    protected String retrieveProxyGrantingTicketFromStorage(String pgtIou) {
        if (this.proxyGrantingTicketStorage != null) {
            return this.proxyGrantingTicketStorage.retrieve(pgtIou);
        }
        return null;
    }

    protected String retrieveProxyGrantingTicketViaEncryption(String encryptedPgt) {
        if (this.privateKey != null) {
            try {
                Cipher cipher = Cipher.getInstance(this.privateKey.getAlgorithm());
                byte[] cred64 = new Base64().decode(encryptedPgt);
                cipher.init(2, this.privateKey);
                byte[] cipherData = cipher.doFinal(cred64);
                String pgt = new String(cipherData);
                this.logger.debug("Decrypted PGT: {}", (Object)pgt);
                return pgt;
            }
            catch (Exception e) {
                this.logger.error("Unable to decrypt PGT", (Throwable)e);
            }
        }
        return null;
    }

    protected static String parsePrincipalFromResponse(String response) {
        return XmlUtils.getTextForElement(response, "user");
    }

    protected static String parseAuthenticationFailureFromResponse(String response) {
        return XmlUtils.getTextForElement(response, "authenticationFailure");
    }

    protected Map<String, Object> extractCustomAttributes(String xml) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            CustomAttributeHandler handler = new CustomAttributeHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(new StringReader(xml)));
            return handler.getAttributes();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected void customParseResponse(String response, Assertion assertion) throws TicketValidationException {
    }

    protected final String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public final void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    protected final ProxyGrantingTicketStorage getProxyGrantingTicketStorage() {
        return this.proxyGrantingTicketStorage;
    }

    public final void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage proxyGrantingTicketStorage) {
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
    }

    protected final ProxyRetriever getProxyRetriever() {
        return this.proxyRetriever;
    }

    public final void setProxyRetriever(ProxyRetriever proxyRetriever) {
        this.proxyRetriever = proxyRetriever;
    }

    private class CustomAttributeHandler
    extends DefaultHandler {
        private Map<String, Object> attributes;
        private boolean foundAttributes;
        private String currentAttribute;
        private StringBuilder value;

        private CustomAttributeHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.attributes = new HashMap<String, Object>();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if ("attributes".equals(localName)) {
                this.foundAttributes = true;
            } else if (this.foundAttributes) {
                this.value = new StringBuilder();
                this.currentAttribute = localName;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if ("attributes".equals(localName)) {
                this.foundAttributes = false;
                this.currentAttribute = null;
            } else if (this.foundAttributes) {
                Object o = this.attributes.get(this.currentAttribute);
                if (o == null) {
                    this.attributes.put(this.currentAttribute, this.value.toString());
                } else {
                    LinkedList<Object> items;
                    if (o instanceof List) {
                        items = (LinkedList<Object>)o;
                    } else {
                        items = new LinkedList<Object>();
                        items.add(o);
                        this.attributes.put(this.currentAttribute, items);
                    }
                    items.add(this.value.toString());
                }
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.currentAttribute != null) {
                this.value.append(chars, start, length);
            }
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }
    }
}

