/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.control.util.PagedResultsClient;
import org.ldaptive.io.LdifReader;
import org.ldaptive.schema.AttributeType;
import org.ldaptive.schema.ObjectClass;
import org.ldaptive.schema.ObjectClassType;
import org.ldaptive.schema.Schema;
import org.ldaptive.schema.SchemaUtils;

public final class SchemaFactory {
    private static final String SCHEMA_NAMING_CONTEXT_ATTR_NAME = "schemaNamingContext";
    private static final String SCHEMA_FILTER = "(|(objectClass=attributeSchema)(objectClass=classSchema))";
    private static final String OBJECT_CLASS_ATTR_NAME = "objectClass";
    private static final String OBJECT_CLASS_CATEGORY_ATTR_NAME = "objectClassCategory";
    private static final String ATTRIBUTE_SCHEMA_ATTR_NAME = "attributeSchema";
    private static final String CLASS_SCHEMA_ATTR_NAME = "classSchema";
    private static final String ATTRIBUTE_ID_ATTR_NAME = "attributeID";
    private static final String LDAP_DISPLAY_NAME_ATTR_NAME = "lDAPDisplayName";
    private static final String ADMIN_DISPLAY_NAME_ATTR_NAME = "adminDisplayName";
    private static final String NAME_ATTR_NAME = "name";
    private static final String ADMIN_DESCRIPTION_ATTR_NAME = "adminDescription";
    private static final String ATTRIBUTE_SYNTAX_ATTR_NAME = "attributeSyntax";
    private static final String IS_SINGLE_VALUED_ATTR_NAME = "isSingleValued";
    private static final String SYSTEM_ONLY_ATTR_NAME = "systemOnly";
    private static final String GOVERNS_ID_ATTR_NAME = "governsID";
    private static final String SUB_CLASS_OF_ATTR_NAME = "subClassOf";
    private static final String MUST_CONTAIN_ATTR_NAME = "mustContain";
    private static final String SYSTEM_MUST_CONTAIN_ATTR_NAME = "systemMustContain";
    private static final String MAY_CONTAIN_ATTR_NAME = "mayContain";
    private static final String SYSTEM_MAY_CONTAIN_ATTR_NAME = "systemMayContain";

    private SchemaFactory() {
    }

    public static Schema createSchema(InputStream is) throws IOException {
        LdifReader reader = new LdifReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        return SchemaFactory.createSchema(reader.read());
    }

    public static Schema createSchema(ConnectionFactory factory) throws LdapException {
        LdapEntry rootDSE = SchemaUtils.getLdapEntry(factory, "", "(objectClass=*)", SCHEMA_NAMING_CONTEXT_ATTR_NAME);
        String entryDn = rootDSE.getAttribute(SCHEMA_NAMING_CONTEXT_ATTR_NAME).getStringValue();
        return SchemaFactory.createSchema(factory, entryDn, SCHEMA_FILTER, ReturnAttributes.ALL.value());
    }

    public static Schema createSchema(ConnectionFactory factory, String entryDn) throws LdapException {
        return SchemaFactory.createSchema(factory, entryDn, SCHEMA_FILTER, ReturnAttributes.ALL.value());
    }

    public static Schema createSchema(SearchResponse schemaResult) {
        HashSet<AttributeType> attributeTypes = new HashSet<AttributeType>();
        HashSet<ObjectClass> objectClasses = new HashSet<ObjectClass>();
        for (LdapEntry entry : schemaResult.getEntries()) {
            entry.processAttribute(OBJECT_CLASS_ATTR_NAME, attr -> {
                if (attr.getStringValues().contains(ATTRIBUTE_SCHEMA_ATTR_NAME)) {
                    attributeTypes.add(SchemaFactory.createAttributeType(entry));
                }
                if (attr.getStringValues().contains(CLASS_SCHEMA_ATTR_NAME)) {
                    objectClasses.add(SchemaFactory.createObjectClass(entry));
                }
            });
        }
        Schema schema = new Schema();
        schema.setAttributeTypes(attributeTypes);
        schema.setObjectClasses(objectClasses);
        return schema;
    }

    private static Schema createSchema(ConnectionFactory factory, String dn, String filter, String ... retAttrs) throws LdapException {
        HashSet<AttributeType> attributeTypes = new HashSet<AttributeType>();
        HashSet<ObjectClass> objectClasses = new HashSet<ObjectClass>();
        PagedResultsClient client = new PagedResultsClient(factory, 100);
        client.setEntryHandlers(entry -> {
            LdapAttribute attr = entry.getAttribute(OBJECT_CLASS_ATTR_NAME);
            if (attr != null) {
                if (attr.getStringValues().contains(ATTRIBUTE_SCHEMA_ATTR_NAME)) {
                    attributeTypes.add(SchemaFactory.createAttributeType(entry));
                }
                if (attr.getStringValues().contains(CLASS_SCHEMA_ATTR_NAME)) {
                    objectClasses.add(SchemaFactory.createObjectClass(entry));
                }
            }
            return null;
        });
        client.executeToCompletion((SearchRequest)SearchRequest.builder().dn(dn).filter(filter).returnAttributes(retAttrs).build());
        Schema schema = new Schema();
        schema.setAttributeTypes(attributeTypes);
        schema.setObjectClasses(objectClasses);
        return schema;
    }

    private static AttributeType createAttributeType(LdapEntry entry) {
        LdapAttribute la = entry.getAttribute(OBJECT_CLASS_ATTR_NAME);
        if (la == null || !la.getStringValues().contains(ATTRIBUTE_SCHEMA_ATTR_NAME)) {
            throw new IllegalArgumentException("Entry is not an attribute schema");
        }
        return new AttributeType(entry.getAttributeStringValue(ATTRIBUTE_ID_ATTR_NAME), SchemaFactory.getFirstAttributeValues(entry, LDAP_DISPLAY_NAME_ATTR_NAME, ADMIN_DISPLAY_NAME_ATTR_NAME, NAME_ATTR_NAME), entry.getAttributeStringValue(ADMIN_DESCRIPTION_ATTR_NAME), false, null, null, null, null, entry.getAttributeStringValue(ATTRIBUTE_SYNTAX_ATTR_NAME), Boolean.parseBoolean(entry.getAttributeStringValue(IS_SINGLE_VALUED_ATTR_NAME)), false, Boolean.parseBoolean(entry.getAttributeStringValue(SYSTEM_ONLY_ATTR_NAME)), null, null);
    }

    private static ObjectClass createObjectClass(LdapEntry entry) {
        LdapAttribute la = entry.getAttribute(OBJECT_CLASS_ATTR_NAME);
        if (la == null || !la.getStringValues().contains(CLASS_SCHEMA_ATTR_NAME)) {
            throw new IllegalArgumentException("Entry is not an object class");
        }
        ObjectClassType ocType = null;
        String ocCategory = entry.getAttributeStringValue(OBJECT_CLASS_CATEGORY_ATTR_NAME);
        if (ocCategory != null) {
            for (ObjectClassType type : ObjectClassType.values()) {
                if (type.ordinal() != Integer.parseInt(ocCategory)) continue;
                ocType = type;
                break;
            }
        }
        return new ObjectClass(entry.getAttributeStringValue(GOVERNS_ID_ATTR_NAME), SchemaFactory.getFirstAttributeValues(entry, LDAP_DISPLAY_NAME_ATTR_NAME, ADMIN_DISPLAY_NAME_ATTR_NAME, NAME_ATTR_NAME), entry.getAttributeStringValue(ADMIN_DESCRIPTION_ATTR_NAME), false, SchemaFactory.getAllAttributeValues(entry, SUB_CLASS_OF_ATTR_NAME), ocType, SchemaFactory.getAllAttributeValues(entry, MUST_CONTAIN_ATTR_NAME, SYSTEM_MUST_CONTAIN_ATTR_NAME), SchemaFactory.getAllAttributeValues(entry, MAY_CONTAIN_ATTR_NAME, SYSTEM_MAY_CONTAIN_ATTR_NAME), null);
    }

    private static String[] getFirstAttributeValues(LdapEntry entry, String ... names) {
        for (String name : names) {
            LdapAttribute la = entry.getAttribute(name);
            if (la == null) continue;
            return la.getStringValues().toArray(new String[0]);
        }
        return null;
    }

    private static String[] getAllAttributeValues(LdapEntry entry, String ... names) {
        ArrayList<String> allValues = new ArrayList<String>();
        for (String name : names) {
            LdapAttribute la = entry.getAttribute(name);
            if (la == null) continue;
            allValues.addAll(la.getStringValues());
        }
        return allValues.isEmpty() ? null : allValues.toArray(new String[0]);
    }
}

