/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Configurable
public class UsernamePasswordAuthenticationProvider
implements AuthenticationProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordAuthenticationProvider.class);
    protected final DomainOps domainOps;
    protected final AuthDataAccessor dataAccessor;
    protected final UserProvisioningManager provisioningManager;
    protected final DefaultCredentialChecker credentialChecker;
    protected final SecurityProperties securityProperties;
    protected final EncryptorManager encryptorManager;

    public UsernamePasswordAuthenticationProvider(DomainOps domainOps, AuthDataAccessor dataAccessor, UserProvisioningManager provisioningManager, DefaultCredentialChecker credentialChecker, SecurityProperties securityProperties, EncryptorManager encryptorManager) {
        this.domainOps = domainOps;
        this.dataAccessor = dataAccessor;
        this.provisioningManager = provisioningManager;
        this.credentialChecker = credentialChecker;
        this.securityProperties = securityProperties;
        this.encryptorManager = encryptorManager;
    }

    public Authentication authenticate(Authentication authentication) {
        Boolean authenticated;
        Optional<Object> domain;
        String domainKey;
        if ("Master".equals(((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain())) {
            domainKey = "Master";
            domain = Optional.empty();
        } else {
            domainKey = ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain();
            try {
                domain = Optional.of(this.domainOps.read(domainKey));
            }
            catch (KeymasterException | NotFoundException e) {
                throw new BadCredentialsException("Could not find domain " + domainKey, e);
            }
        }
        MutableObject username = new MutableObject();
        MutableObject delegationKey = new MutableObject();
        if (this.securityProperties.getAnonymousUser().equals(authentication.getName())) {
            username.setValue((Object)this.securityProperties.getAnonymousUser());
            this.credentialChecker.checkIsDefaultAnonymousKeyInUse();
            authenticated = authentication.getCredentials().toString().equals(this.securityProperties.getAnonymousKey());
        } else if (this.securityProperties.getAdminUser().equals(authentication.getName())) {
            username.setValue((Object)this.securityProperties.getAdminUser());
            if ("Master".equals(domainKey)) {
                this.credentialChecker.checkIsDefaultAdminPasswordInUse();
                authenticated = this.encryptorManager.getInstance().verify(authentication.getCredentials().toString(), this.securityProperties.getAdminPasswordAlgorithm(), this.securityProperties.getAdminPassword());
            } else if (domain.isPresent()) {
                authenticated = this.encryptorManager.getInstance().verify(authentication.getCredentials().toString(), ((Domain)domain.get()).getAdminCipherAlgorithm(), ((Domain)domain.get()).getAdminPassword());
            } else {
                LOG.error("Could not read admin credentials for domain {}", (Object)domainKey);
                authenticated = false;
            }
        } else {
            Triple authResult = AuthContextUtils.callAsAdmin(domainKey, () -> this.dataAccessor.authenticate(domainKey, authentication));
            authenticated = (Boolean)authResult.getMiddle();
            if (authResult.getLeft() != null && authResult.getMiddle() != null) {
                username.setValue((Object)((User)authResult.getLeft()).getUsername());
                if (!authenticated.booleanValue()) {
                    AuthContextUtils.runAsAdmin(domainKey, () -> this.provisioningManager.internalSuspend(((User)authResult.getLeft()).getKey(), this.securityProperties.getAdminUser(), "Failed authentication"));
                }
            }
            delegationKey.setValue((Object)((String)authResult.getRight()));
        }
        if (username.get() == null) {
            username.setValue((Object)authentication.getPrincipal().toString());
        }
        return this.finalizeAuthentication(authenticated, domainKey, (String)username.get(), (String)delegationKey.get(), authentication);
    }

    protected Authentication finalizeAuthentication(Boolean authenticated, String domain, String username, String delegationKey, Authentication authentication) {
        if (!BooleanUtils.isTrue((Boolean)authenticated)) {
            this.dataAccessor.audit(domain, username, delegationKey, OpEvent.Outcome.FAILURE, false, authentication, "Not authenticated");
            LOG.debug("User {} not authenticated", (Object)username);
            throw new BadCredentialsException("User " + username + " not authenticated");
        }
        UsernamePasswordAuthenticationToken token = AuthContextUtils.callAsAdmin(domain, () -> {
            UsernamePasswordAuthenticationToken upat = new UsernamePasswordAuthenticationToken((Object)username, null, this.dataAccessor.getAuthorities(username, delegationKey));
            upat.setDetails(authentication.getDetails());
            this.dataAccessor.audit(domain, username, delegationKey, OpEvent.Outcome.SUCCESS, true, authentication, "Successfully authenticated, with entitlements: " + String.valueOf(upat.getAuthorities()));
            return upat;
        });
        LOG.debug("User {} successfully authenticated, with entitlements {}", (Object)username, (Object)token.getAuthorities());
        return token;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

