/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiPanel;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.common.lib.policy.AbstractCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.DefaultInboundCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.DefaultPushCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.InboundPolicyTO;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.policy.ProvisioningPolicyTO;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ProvisioningPolicyModalPanel
extends AbstractModalPanel<ProvisioningPolicyTO> {
    private static final long serialVersionUID = 2988891313881271124L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    @SpringBean
    protected PolicyRestClient policyRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    protected final IModel<Map<String, ImplementationTO>> implementations;
    private final IModel<List<CorrelationRule>> model;

    public ProvisioningPolicyModalPanel(final ProvisioningPolicyTO policyTO, BaseModal<? extends ProvisioningPolicyTO> modal, PageReference pageRef) {
        super(modal, pageRef);
        modal.setFormModel((Serializable)policyTO);
        this.implementations = new LoadableDetachableModel<Map<String, ImplementationTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<String, ImplementationTO> load() {
                return ProvisioningPolicyModalPanel.this.implementationRestClient.list(policyTO instanceof InboundPolicyTO ? "INBOUND_CORRELATION_RULE" : "PUSH_CORRELATION_RULE").stream().collect(Collectors.toMap(ImplementationTO::getKey, Function.identity()));
            }
        };
        this.model = new PropertyModel<List<CorrelationRule>>((Object)policyTO, "correlationRules"){
            private static final long serialVersionUID = -8168676563540297301L;
            private final List<CorrelationRule> rules;
            {
                super(modelObject, expression);
                this.rules = policyTO.getCorrelationRules().keySet().stream().map(anyType -> new CorrelationRule(policyTO instanceof InboundPolicyTO ? DefaultInboundCorrelationRuleConf.class : DefaultPushCorrelationRuleConf.class, (String)anyType, (ImplementationTO)((Map)ProvisioningPolicyModalPanel.this.implementations.getObject()).get(policyTO.getCorrelationRules().get(anyType)))).collect(Collectors.toList());
            }

            public List<CorrelationRule> getObject() {
                return this.rules;
            }

            public void setObject(List<CorrelationRule> object) {
                policyTO.getCorrelationRules().clear();
                this.rules.forEach(rule -> policyTO.getCorrelationRules().put(rule.getAnyType(), rule.getImpl().getKey()));
            }
        };
        this.add(new Component[]{new MultiPanel<CorrelationRule>("correlationRules", "correlationRules", this.model){
            private static final long serialVersionUID = -2481579077338205547L;

            protected CorrelationRule newModelObject() {
                return new CorrelationRule(policyTO instanceof InboundPolicyTO ? DefaultInboundCorrelationRuleConf.class : DefaultPushCorrelationRuleConf.class);
            }

            protected CorrelationRulePanel getItemPanel(ListItem<CorrelationRule> item) {
                return new CorrelationRulePanel("panel", (IModel<CorrelationRule>)Model.of((Serializable)((CorrelationRule)item.getModelObject())));
            }

            protected void sendError(String message) {
                SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("operation_error")));
            }
        }});
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            ((ProvisioningPolicyTO)this.getItem()).getCorrelationRules().clear();
            ((List)this.model.getObject()).forEach(rule -> {
                ((ProvisioningPolicyTO)this.getItem()).getCorrelationRules().put(rule.getAnyType(), rule.getImplKey());
                if (rule.getImpl().getEngine() == ImplementationEngine.JAVA && rule.getDefaultRuleConf() != null) {
                    try {
                        this.implementationRestClient.update(rule.getImpl());
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException((Throwable)e);
                    }
                }
            });
            this.policyRestClient.update(this.getItem() instanceof InboundPolicyTO ? PolicyType.INBOUND : PolicyType.PUSH, (PolicyTO)((ProvisioningPolicyTO)this.getItem()));
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating/updating policy", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    private class CorrelationRule
    implements Serializable {
        private static final long serialVersionUID = 4221521483948294336L;
        private final Class<? extends AbstractCorrelationRuleConf> ruleConfClass;
        private String anyType;
        private ImplementationTO impl;
        private AbstractCorrelationRuleConf defaultRuleConf;

        CorrelationRule(Class<? extends AbstractCorrelationRuleConf> ruleConfClass) {
            this.ruleConfClass = ruleConfClass;
            this.anyType = AnyTypeKind.USER.name();
        }

        CorrelationRule(Class<? extends AbstractCorrelationRuleConf> ruleConfClass, String anyType, ImplementationTO impl) {
            this.ruleConfClass = ruleConfClass;
            this.anyType = anyType;
            this.setImpl(impl);
        }

        public String getAnyType() {
            return this.anyType;
        }

        public void setAnyType(String anyType) {
            this.anyType = anyType;
        }

        public String getImplKey() {
            return Optional.ofNullable(this.impl).map(ImplementationTO::getKey).orElse(null);
        }

        public void setImplKey(String key) {
            this.setImpl((ImplementationTO)((Map)ProvisioningPolicyModalPanel.this.implementations.getObject()).get(key));
        }

        public final void setImpl(ImplementationTO impl) {
            this.impl = impl;
            if (impl != null) {
                this.defaultRuleConf = null;
                try {
                    this.defaultRuleConf = (AbstractCorrelationRuleConf)MAPPER.readValue(impl.getBody(), this.ruleConfClass);
                }
                catch (Exception e) {
                    LOG.debug("Could not deserialize {} as {}", (Object)impl.getBody(), (Object)this.ruleConfClass.getName());
                }
            }
        }

        public ImplementationTO getImpl() {
            if (this.defaultRuleConf != null) {
                try {
                    this.impl.setBody(MAPPER.writeValueAsString((Object)this.defaultRuleConf));
                }
                catch (Exception e) {
                    LOG.error("Could not serialize {}", (Object)this.defaultRuleConf);
                }
            }
            return this.impl;
        }

        public void setDefaultRuleConf(DefaultPushCorrelationRuleConf defaultRuleConf) {
            this.defaultRuleConf = defaultRuleConf;
        }

        public AbstractCorrelationRuleConf getDefaultRuleConf() {
            return this.defaultRuleConf;
        }
    }

    protected class CorrelationRulePanel
    extends Panel {
        private static final long serialVersionUID = -5380414818290018189L;

        CorrelationRulePanel(String id, final IModel<CorrelationRule> correlationRule) {
            super(id);
            AjaxDropDownChoicePanel anyType = new AjaxDropDownChoicePanel("anyType", "anyType", (IModel)new PropertyModel(correlationRule.getObject(), "anyType")).setNullValid(true).setChoices(ProvisioningPolicyModalPanel.this.anyTypeRestClient.list());
            anyType.setNullValid(false);
            anyType.setRequired(true);
            anyType.setOutputMarkupId(true);
            this.add(new Component[]{anyType});
            AjaxDropDownChoicePanel rule = new AjaxDropDownChoicePanel("rule", "rule", (IModel)new PropertyModel(correlationRule.getObject(), "implKey")).setChoices(((Map)ProvisioningPolicyModalPanel.this.implementations.getObject()).keySet().stream().sorted().collect(Collectors.toList()));
            rule.setNullValid(false);
            rule.setRequired(true);
            rule.setOutputMarkupId(true);
            this.add(new Component[]{rule});
            PropertyModel<Boolean> orSchemasModel = new PropertyModel<Boolean>((Object)((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf(), "orSchemas"){
                private static final long serialVersionUID = 807008909842554829L;

                public Boolean getObject() {
                    Boolean bl;
                    AbstractCorrelationRuleConf conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    if (conf instanceof DefaultInboundCorrelationRuleConf) {
                        DefaultInboundCorrelationRuleConf dicrc = (DefaultInboundCorrelationRuleConf)conf;
                        bl = dicrc.isOrSchemas();
                    } else if (conf instanceof DefaultPushCorrelationRuleConf) {
                        DefaultPushCorrelationRuleConf dpcrc = (DefaultPushCorrelationRuleConf)conf;
                        bl = dpcrc.isOrSchemas();
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public void setObject(Boolean object) {
                    AbstractCorrelationRuleConf conf;
                    AbstractCorrelationRuleConf abstractCorrelationRuleConf = conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    Objects.requireNonNull(abstractCorrelationRuleConf);
                    AbstractCorrelationRuleConf abstractCorrelationRuleConf2 = abstractCorrelationRuleConf;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultInboundCorrelationRuleConf.class, DefaultPushCorrelationRuleConf.class}, (Object)abstractCorrelationRuleConf2, n)) {
                        case 0: {
                            DefaultInboundCorrelationRuleConf dicrc = (DefaultInboundCorrelationRuleConf)abstractCorrelationRuleConf2;
                            dicrc.setOrSchemas(object.booleanValue());
                            break;
                        }
                        case 1: {
                            DefaultPushCorrelationRuleConf dpcrc = (DefaultPushCorrelationRuleConf)abstractCorrelationRuleConf2;
                            dpcrc.setOrSchemas(object.booleanValue());
                            break;
                        }
                    }
                }
            };
            final AjaxCheckBoxPanel orSchemas = new AjaxCheckBoxPanel("orSchemas", "orSchemas", (IModel)orSchemasModel, false);
            orSchemas.setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{orSchemas.setVisible(((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null)});
            PropertyModel<List<String>> defaultRuleConfModel = new PropertyModel<List<String>>((Object)((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf(), "schemas"){
                private static final long serialVersionUID = 3799387950428254072L;

                private List<String> schemas() {
                    List list;
                    AbstractCorrelationRuleConf conf = ((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf();
                    if (conf instanceof DefaultInboundCorrelationRuleConf) {
                        DefaultInboundCorrelationRuleConf dicrc = (DefaultInboundCorrelationRuleConf)conf;
                        list = dicrc.getSchemas();
                    } else if (conf instanceof DefaultPushCorrelationRuleConf) {
                        DefaultPushCorrelationRuleConf dpcrc = (DefaultPushCorrelationRuleConf)conf;
                        list = dpcrc.getSchemas();
                    } else {
                        list = List.of();
                    }
                    return list;
                }

                public List<String> getObject() {
                    ArrayList<String> schemas = new ArrayList<String>();
                    if (((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null) {
                        schemas.addAll(this.schemas());
                    }
                    return schemas;
                }

                public void setObject(List<String> object) {
                    if (((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null) {
                        this.schemas().clear();
                        this.schemas().addAll(object);
                    }
                }
            };
            final AjaxPalettePanel defaultRuleConf = new AjaxPalettePanel.Builder().setName("defaultRuleConf").build("defaultRuleConf", (IModel)defaultRuleConfModel, (AjaxPalettePanel.Builder.Query)new AjaxPalettePanel.Builder.Query<String>(){
                private static final long serialVersionUID = -7223078772249308813L;

                public List<String> execute(String filter) {
                    return CorrelationRulePanel.this.getSchemas((CorrelationRule)correlationRule.getObject());
                }
            });
            defaultRuleConf.hideLabel().setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{defaultRuleConf.setVisible(((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() != null)});
            anyType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (orSchemas.isVisibleInHierarchy()) {
                        target.add(new Component[]{orSchemas});
                    }
                    if (defaultRuleConf.isVisibleInHierarchy()) {
                        ((CorrelationRule)correlationRule.getObject()).setImpl(null);
                        defaultRuleConf.reload(target);
                        target.add(new Component[]{defaultRuleConf});
                    }
                }
            }});
            rule.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (((CorrelationRule)correlationRule.getObject()).getDefaultRuleConf() == null) {
                        orSchemas.setVisible(false);
                        defaultRuleConf.setVisible(false);
                    } else {
                        orSchemas.setVisible(true);
                        defaultRuleConf.setVisible(true);
                    }
                    target.add(new Component[]{orSchemas});
                    target.add(new Component[]{defaultRuleConf});
                }
            }});
        }

        private List<String> getSchemas(CorrelationRule rule) {
            ArrayList<String> choices = StringUtils.isEmpty((CharSequence)rule.getAnyType()) ? new ArrayList<String>() : ProvisioningPolicyModalPanel.this.schemaRestClient.getSchemas(SchemaType.PLAIN, rule.getAnyType().equals(AnyTypeKind.USER.name()) ? AnyTypeKind.USER : (rule.getAnyType().equals(AnyTypeKind.GROUP.name()) ? AnyTypeKind.GROUP : AnyTypeKind.ANY_OBJECT)).stream().map(SchemaTO::getKey).collect(Collectors.toList());
            choices.add("key");
            choices.add(rule.getAnyType().equals(AnyTypeKind.USER.name()) ? "username" : "name");
            Collections.sort(choices);
            return choices;
        }
    }
}

