/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.attr;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.AttributeDefinitionResolutionContext;
import org.apereo.cas.authentication.attribute.DefaultAttributeDefinition;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class SamlIdPAttributeDefinition
extends DefaultAttributeDefinition {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPAttributeDefinition.class);
    private static final long serialVersionUID = -144152003366303322L;
    private String friendlyName;
    private String urn;
    private boolean persistent;
    private String salt;

    public List<Object> resolveAttributeValues(AttributeDefinitionResolutionContext context) throws Throwable {
        if (this.isPersistent() && StringUtils.isNotBlank((CharSequence)this.salt)) {
            String givenSalt = SpringExpressionLanguageValueResolver.getInstance().resolve(this.salt);
            ShibbolethCompatiblePersistentIdGenerator generator = new ShibbolethCompatiblePersistentIdGenerator(givenSalt);
            String finalValue = generator.generate(context.getPrincipal(), context.getService());
            LOGGER.debug("Generated persistent attribute definition value [{}] for [{}]", (Object)finalValue, (Object)this.getKey());
            return CollectionUtils.wrapList((Object[])new Object[]{finalValue});
        }
        return super.resolveAttributeValues(context);
    }

    @Generated
    protected SamlIdPAttributeDefinition(SamlIdPAttributeDefinitionBuilder<?, ?> b) {
        super(b);
        this.friendlyName = b.friendlyName;
        this.urn = b.urn;
        this.persistent = b.persistent;
        this.salt = b.salt;
    }

    @Generated
    public static SamlIdPAttributeDefinitionBuilder<?, ?> builder() {
        return new SamlIdPAttributeDefinitionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "SamlIdPAttributeDefinition(super=" + super.toString() + ", friendlyName=" + this.friendlyName + ", urn=" + this.urn + ", persistent=" + this.persistent + ", salt=" + this.salt + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SamlIdPAttributeDefinition)) {
            return false;
        }
        SamlIdPAttributeDefinition other = (SamlIdPAttributeDefinition)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.persistent != other.persistent) {
            return false;
        }
        String this$friendlyName = this.friendlyName;
        String other$friendlyName = other.friendlyName;
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$urn = this.urn;
        String other$urn = other.urn;
        if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
            return false;
        }
        String this$salt = this.salt;
        String other$salt = other.salt;
        return !(this$salt == null ? other$salt != null : !this$salt.equals(other$salt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SamlIdPAttributeDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.persistent ? 79 : 97);
        String $friendlyName = this.friendlyName;
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $urn = this.urn;
        result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
        String $salt = this.salt;
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        return result;
    }

    @Generated
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Generated
    public String getUrn() {
        return this.urn;
    }

    @Generated
    public boolean isPersistent() {
        return this.persistent;
    }

    @Generated
    public String getSalt() {
        return this.salt;
    }

    @Generated
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Generated
    public void setUrn(String urn) {
        this.urn = urn;
    }

    @Generated
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Generated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Generated
    public SamlIdPAttributeDefinition(String friendlyName, String urn, boolean persistent, String salt) {
        this.friendlyName = friendlyName;
        this.urn = urn;
        this.persistent = persistent;
        this.salt = salt;
    }

    @Generated
    public SamlIdPAttributeDefinition() {
    }

    @Generated
    public SamlIdPAttributeDefinition withFriendlyName(String friendlyName) {
        return this.friendlyName == friendlyName ? this : new SamlIdPAttributeDefinition(friendlyName, this.urn, this.persistent, this.salt);
    }

    @Generated
    public SamlIdPAttributeDefinition withUrn(String urn) {
        return this.urn == urn ? this : new SamlIdPAttributeDefinition(this.friendlyName, urn, this.persistent, this.salt);
    }

    @Generated
    public SamlIdPAttributeDefinition withPersistent(boolean persistent) {
        return this.persistent == persistent ? this : new SamlIdPAttributeDefinition(this.friendlyName, this.urn, persistent, this.salt);
    }

    @Generated
    public SamlIdPAttributeDefinition withSalt(String salt) {
        return this.salt == salt ? this : new SamlIdPAttributeDefinition(this.friendlyName, this.urn, this.persistent, salt);
    }

    @Generated
    public static abstract class SamlIdPAttributeDefinitionBuilder<C extends SamlIdPAttributeDefinition, B extends SamlIdPAttributeDefinitionBuilder<C, B>>
    extends DefaultAttributeDefinition.DefaultAttributeDefinitionBuilder<C, B> {
        @Generated
        private String friendlyName;
        @Generated
        private String urn;
        @Generated
        private boolean persistent;
        @Generated
        private String salt;

        @Generated
        public B friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return (B)this.self();
        }

        @Generated
        public B urn(String urn) {
            this.urn = urn;
            return (B)this.self();
        }

        @Generated
        public B persistent(boolean persistent) {
            this.persistent = persistent;
            return (B)this.self();
        }

        @Generated
        public B salt(String salt) {
            this.salt = salt;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SamlIdPAttributeDefinition.SamlIdPAttributeDefinitionBuilder(super=" + super.toString() + ", friendlyName=" + this.friendlyName + ", urn=" + this.urn + ", persistent=" + this.persistent + ", salt=" + this.salt + ")";
        }
    }

    @Generated
    private static final class SamlIdPAttributeDefinitionBuilderImpl
    extends SamlIdPAttributeDefinitionBuilder<SamlIdPAttributeDefinition, SamlIdPAttributeDefinitionBuilderImpl> {
        @Generated
        private SamlIdPAttributeDefinitionBuilderImpl() {
        }

        @Override
        @Generated
        protected SamlIdPAttributeDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SamlIdPAttributeDefinition build() {
            return new SamlIdPAttributeDefinition(this);
        }
    }
}

