/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.authentication.SamlIdPAuthenticationContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class SamlIdPSessionManager {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSessionManager.class);
    private final OpenSamlConfigBean openSamlConfigBean;
    private final SessionStore sessionStore;

    public static SamlIdPSessionManager of(OpenSamlConfigBean openSamlConfigBean, SessionStore sessionStore) {
        return new SamlIdPSessionManager(openSamlConfigBean, sessionStore);
    }

    @CanIgnoreReturnValue
    public SamlIdPSessionManager store(WebContext webContext, Pair<? extends SignableSAMLObject, MessageContext> context) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)context.getLeft();
        MessageContext messageContext = (MessageContext)context.getValue();
        try (StringWriter writer = SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)authnRequest);){
            String samlRequest = EncodingUtils.encodeBase64((byte[])writer.toString().getBytes(StandardCharsets.UTF_8));
            String authnContext = SamlIdPAuthenticationContext.from(messageContext).encode();
            SamlIdPSessionEntry entry = new SamlIdPSessionEntry().setId(authnRequest.getID()).setSamlRequest(samlRequest).setRelayState(SAMLBindingSupport.getRelayState((MessageContext)messageContext)).setContext(authnContext);
            Optional currentContext = this.sessionStore.get(webContext, SamlIdPSessionEntry.class.getName());
            Map entries = currentContext.map(ctx -> (Map)ctx).orElseGet(HashMap::new);
            entries.put(entry.getId(), entry);
            this.sessionStore.set(webContext, SamlIdPSessionEntry.class.getName(), (Object)entries);
        }
        return this;
    }

    public Optional<Pair<? extends RequestAbstractType, MessageContext>> fetch(WebContext context, Class<? extends RequestAbstractType> clazz) {
        LOGGER.trace("Attempting to fetch SAML2 authentication session from [{}]", (Object)context.getFullRequestURL());
        Optional currentContext = this.sessionStore.get(context, SamlIdPSessionEntry.class.getName());
        return currentContext.map(ctx -> (Map)ctx).flatMap(ctx -> context.getRequestParameter("srid").map(ctx::get).or(Unchecked.supplier(() -> this.getSamlIdPSessionEntryFromRequest(context, (Map<String, SamlIdPSessionEntry>)ctx)))).filter(entry -> StringUtils.isNotBlank((CharSequence)entry.getSamlRequest())).map(entry -> {
            Object authnRequest = this.fetch(clazz, entry.getSamlRequest());
            MessageContext messageContext = SamlIdPAuthenticationContext.decode(entry.getContext()).toMessageContext(authnRequest);
            return Pair.of((Object)((AuthnRequest)messageContext.getMessage()), (Object)messageContext);
        });
    }

    public <T extends RequestAbstractType> T fetch(Class<T> clazz, String requestValue) {
        return (T)SamlUtils.convertToSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (String)requestValue, clazz);
    }

    private Optional<SamlIdPSessionEntry> getSamlIdPSessionEntryFromRequest(WebContext context, Map<String, SamlIdPSessionEntry> ctx) {
        ConfigurableApplicationContext applicationContext = this.openSamlConfigBean.getApplicationContext();
        ArgumentExtractor argumentExtractor = (ArgumentExtractor)applicationContext.getBean("argumentExtractor", ArgumentExtractor.class);
        WebApplicationService service = argumentExtractor.extractService(((JEEContext)context).getNativeRequest());
        return Optional.ofNullable(service).map(Unchecked.function(__ -> {
            AuthenticationServiceSelectionPlan serviceSelectionPlan = (AuthenticationServiceSelectionPlan)applicationContext.getBean("authenticationServiceSelectionPlan", AuthenticationServiceSelectionPlan.class);
            Service resolvedService = serviceSelectionPlan.resolveService((Service)service);
            Object authnRequestId = resolvedService.getAttributes().get("srid");
            return CollectionUtils.firstElement(authnRequestId).map(Object::toString).map(ctx::get).orElse(null);
        }));
    }

    @Generated
    public SamlIdPSessionManager(OpenSamlConfigBean openSamlConfigBean, SessionStore sessionStore) {
        this.openSamlConfigBean = openSamlConfigBean;
        this.sessionStore = sessionStore;
    }

    private static final class SamlIdPSessionEntry
    implements Serializable {
        private static final long serialVersionUID = 8119055575574523810L;
        private String id;
        private String samlRequest;
        private String relayState;
        private String context;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getSamlRequest() {
            return this.samlRequest;
        }

        @Generated
        public String getRelayState() {
            return this.relayState;
        }

        @Generated
        public String getContext() {
            return this.context;
        }

        @Generated
        public SamlIdPSessionEntry setId(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SamlIdPSessionEntry setSamlRequest(String samlRequest) {
            this.samlRequest = samlRequest;
            return this;
        }

        @Generated
        public SamlIdPSessionEntry setRelayState(String relayState) {
            this.relayState = relayState;
            return this;
        }

        @Generated
        public SamlIdPSessionEntry setContext(String context) {
            this.context = context;
            return this;
        }

        @Generated
        public SamlIdPSessionEntry() {
        }
    }
}

