/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.webauthn.WebAuthnMultifactorAuthenticationProperties;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.webauthn.WebAuthnMultifactorBypassEvaluator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.WebAuthn})
@Configuration(value="WebAuthnMultifactorProviderBypassConfiguration", proxyBeanMethods=false)
class WebAuthnMultifactorProviderBypassConfiguration {
    WebAuthnMultifactorProviderBypassConfiguration() {
    }

    @ConditionalOnMissingBean(name={"webAuthnBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
        WebAuthnMultifactorAuthenticationProperties webauthn = casProperties.getAuthn().getMfa().getWebAuthn();
        Collection currentBypassEvaluators = applicationContext.getBeansWithAnnotation(WebAuthnMultifactorBypassEvaluator.class).values();
        currentBypassEvaluators.stream().filter(BeanSupplier::isNotProxy).map(MultifactorAuthenticationProviderBypassEvaluator.class::cast).filter(evaluator -> !evaluator.isEmpty()).map(evaluator -> evaluator.belongsToMultifactorAuthenticationProvider(webauthn.getId())).filter(Optional::isPresent).map(Optional::get).sorted((Comparator<MultifactorAuthenticationProviderBypassEvaluator>)AnnotationAwareOrderComparator.INSTANCE).forEach(arg_0 -> ((DefaultChainingMultifactorAuthenticationBypassProvider)bypass).addMultifactorAuthenticationProviderBypassEvaluator(arg_0));
        return bypass;
    }

    @ConditionalOnMissingBean(name={"webAuthnRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(webAuthn.getId(), applicationContext);
    }

    @ConditionalOnMissingBean(name={"webAuthnRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnRestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.web-authn.bypass.rest.url").given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new RestMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId(), applicationContext)).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"webAuthnGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnGroovyMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.web-authn.bypass.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
            MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
            return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"webAuthnHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnHttpRequestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        boolean bypassActive = StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress());
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(bypassActive).supply(() -> new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"webAuthnCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnCredentialMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())).supply(() -> new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId(), applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"webAuthnRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnRegisteredServiceMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(webAuthn.getId(), applicationContext);
    }

    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"webAuthnPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnPrincipalMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())).supply(() -> new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @WebAuthnMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"webAuthnAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator webAuthnAuthenticationMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        WebAuthnMultifactorAuthenticationProperties webAuthn = casProperties.getAuthn().getMfa().getWebAuthn();
        MultifactorAuthenticationProviderBypassProperties props = webAuthn.getBypass();
        boolean bypassActive = StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName());
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(bypassActive).supply(() -> new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, webAuthn.getId(), applicationContext)).otherwiseProxy().get();
    }
}

