/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.InboundPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PropagationPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccessPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAttrReleasePolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAuthPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAInboundCorrelationRuleEntity;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAInboundPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPropagationPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushCorrelationRuleEntity;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPATicketExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAPolicyDAO
implements PolicyDAO {
    protected static final Logger LOG = LoggerFactory.getLogger(PolicyDAO.class);
    protected final RealmDAO realmDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final CASSPClientAppDAO casSPClientAppDAO;
    protected final OIDCRPClientAppDAO oidcRPClientAppDAO;
    protected final SAML2SPClientAppDAO saml2SPClientAppDAO;
    protected final EntityCacheDAO entityCacheDAO;
    protected final EntityManager entityManager;

    protected static <T extends Policy> Class<? extends AbstractPolicy> getEntityReference(Class<T> reference) {
        return AccountPolicy.class.isAssignableFrom(reference) ? JPAAccountPolicy.class : (PasswordPolicy.class.isAssignableFrom(reference) ? JPAPasswordPolicy.class : (PropagationPolicy.class.isAssignableFrom(reference) ? JPAPropagationPolicy.class : (InboundPolicy.class.isAssignableFrom(reference) ? JPAInboundPolicy.class : (PushPolicy.class.isAssignableFrom(reference) ? JPAPushPolicy.class : (AuthPolicy.class.isAssignableFrom(reference) ? JPAAuthPolicy.class : (AccessPolicy.class.isAssignableFrom(reference) ? JPAAccessPolicy.class : (AttrReleasePolicy.class.isAssignableFrom(reference) ? JPAAttrReleasePolicy.class : (TicketExpirationPolicy.class.isAssignableFrom(reference) ? JPATicketExpirationPolicy.class : null))))))));
    }

    public JPAPolicyDAO(RealmDAO realmDAO, ExternalResourceDAO resourceDAO, CASSPClientAppDAO casSPClientAppDAO, OIDCRPClientAppDAO oidcRPClientAppDAO, SAML2SPClientAppDAO saml2SPClientAppDAO, EntityCacheDAO entityCacheDAO, EntityManager entityManager) {
        this.realmDAO = realmDAO;
        this.resourceDAO = resourceDAO;
        this.casSPClientAppDAO = casSPClientAppDAO;
        this.oidcRPClientAppDAO = oidcRPClientAppDAO;
        this.saml2SPClientAppDAO = saml2SPClientAppDAO;
        this.entityCacheDAO = entityCacheDAO;
        this.entityManager = entityManager;
    }

    public boolean existsById(String key) {
        return this.findById(key).isPresent();
    }

    public Optional<? extends Policy> findById(String key) {
        return Optional.ofNullable((AbstractPolicy)this.entityManager.find(AbstractPolicy.class, (Object)key));
    }

    public <T extends Policy> Optional<T> findById(String key, Class<T> reference) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAPolicyDAO.getEntityReference(reference).getSimpleName() + " e WHERE e.id=:key", reference);
        query.setParameter("key", (Object)key);
        Policy result = null;
        try {
            result = (Policy)query.getSingleResult();
        }
        catch (Exception e) {
            LOG.debug("{} with key {} not found", new Object[]{reference.getName(), key, e});
        }
        return Optional.ofNullable(result);
    }

    public long count() {
        TypedQuery query = this.entityManager.createQuery("SELECT COUNT(e) FROM " + AbstractPolicy.class.getSimpleName() + " e", Policy.class);
        return ((Number)query.getSingleResult()).longValue();
    }

    public List<? extends Policy> findAll() {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + AbstractPolicy.class.getSimpleName() + " e", Policy.class);
        return query.getResultList();
    }

    public <T extends Policy> List<T> findAll(Class<T> reference) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAPolicyDAO.getEntityReference(reference).getSimpleName() + " e", reference);
        return query.getResultList();
    }

    public List<AccountPolicy> findByAccountRule(Implementation accountRule) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAAccountPolicy.class.getSimpleName() + " e WHERE :accountRule MEMBER OF e.rules", AccountPolicy.class);
        query.setParameter("accountRule", (Object)accountRule);
        return query.getResultList();
    }

    public List<PasswordPolicy> findByPasswordRule(Implementation passwordRule) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAPasswordPolicy.class.getSimpleName() + " e WHERE :passwordRule MEMBER OF e.rules", PasswordPolicy.class);
        query.setParameter("passwordRule", (Object)passwordRule);
        return query.getResultList();
    }

    public List<InboundPolicy> findByInboundCorrelationRule(Implementation correlationRule) {
        TypedQuery query = this.entityManager.createQuery("SELECT DISTINCT e.inboundPolicy FROM " + JPAInboundCorrelationRuleEntity.class.getSimpleName() + " e WHERE e.implementation=:correlationRule", InboundPolicy.class);
        query.setParameter("correlationRule", (Object)correlationRule);
        return query.getResultList();
    }

    public List<PushPolicy> findByPushCorrelationRule(Implementation correlationRule) {
        TypedQuery query = this.entityManager.createQuery("SELECT DISTINCT e.pushPolicy FROM " + JPAPushCorrelationRuleEntity.class.getSimpleName() + " e WHERE e.implementation=:correlationRule", PushPolicy.class);
        query.setParameter("correlationRule", (Object)correlationRule);
        return query.getResultList();
    }

    public List<AccountPolicy> findByResource(ExternalResource resource) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAAccountPolicy.class.getSimpleName() + " e WHERE :resource MEMBER OF e.resources", AccountPolicy.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public <P extends Policy> P save(P policy) {
        Policy merged = (Policy)this.entityManager.merge(policy);
        if (policy instanceof AccountPolicy || policy instanceof PasswordPolicy || policy instanceof PropagationPolicy || policy instanceof InboundPolicy || policy instanceof PushPolicy) {
            this.resourceDAO.findByPolicy(policy).forEach(resource -> this.entityCacheDAO.evict(JPAExternalResource.class, resource.getKey()));
        }
        return (P)merged;
    }

    public void delete(Policy policy) {
        if (policy instanceof AccountPolicy) {
            this.realmDAO.findByPolicy(policy).forEach(realm -> realm.setAccountPolicy(null));
            this.resourceDAO.findByPolicy(policy).forEach(resource -> resource.setAccountPolicy(null));
        } else if (policy instanceof PasswordPolicy) {
            this.realmDAO.findByPolicy(policy).forEach(realm -> realm.setPasswordPolicy(null));
            this.resourceDAO.findByPolicy(policy).forEach(resource -> resource.setPasswordPolicy(null));
        } else if (policy instanceof PropagationPolicy) {
            this.resourceDAO.findByPolicy(policy).forEach(resource -> resource.setPropagationPolicy(null));
        } else if (policy instanceof InboundPolicy) {
            this.resourceDAO.findByPolicy(policy).forEach(resource -> resource.setInboundPolicy(null));
        } else if (policy instanceof PushPolicy) {
            this.resourceDAO.findByPolicy(policy).forEach(resource -> resource.setPushPolicy(null));
        } else if (policy instanceof AuthPolicy) {
            this.realmDAO.findByPolicy(policy).forEach(realm -> realm.setAuthPolicy(null));
            this.casSPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAuthPolicy(null));
            this.oidcRPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAuthPolicy(null));
            this.saml2SPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAuthPolicy(null));
        } else if (policy instanceof AccessPolicy) {
            this.realmDAO.findByPolicy(policy).forEach(realm -> realm.setAccessPolicy(null));
            this.casSPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAccessPolicy(null));
            this.oidcRPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAccessPolicy(null));
            this.saml2SPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAccessPolicy(null));
        } else if (policy instanceof AttrReleasePolicy) {
            this.realmDAO.findByPolicy(policy).forEach(realm -> realm.setAttrReleasePolicy(null));
            this.casSPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAttrReleasePolicy(null));
            this.oidcRPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAttrReleasePolicy(null));
            this.saml2SPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setAttrReleasePolicy(null));
        } else if (policy instanceof TicketExpirationPolicy) {
            this.realmDAO.findByPolicy(policy).forEach(realm -> realm.setTicketExpirationPolicy(null));
            this.casSPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setTicketExpirationPolicy(null));
            this.oidcRPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setTicketExpirationPolicy(null));
            this.saml2SPClientAppDAO.findAllByPolicy(policy).forEach(clientApp -> clientApp.setTicketExpirationPolicy(null));
        }
        this.entityManager.remove((Object)policy);
    }

    public void deleteById(String key) {
        this.findById(key).ifPresent(this::delete);
    }
}

