/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAttributable;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

public abstract class JSONEntityListener<A extends Attributable> {
    protected static final TypeReference<List<PlainAttr>> TYPEREF = new TypeReference<List<PlainAttr>>(){};

    protected List<PlainAttr> getAttrs(String plainAttrsJSON) {
        return (List)POJOHelper.deserialize((String)plainAttrsJSON, TYPEREF);
    }

    protected void json2list(AbstractAttributable entity, boolean clearFirst) {
        if (clearFirst) {
            entity.getPlainAttrsList().clear();
        }
        if (entity.getPlainAttrsJSON() != null) {
            this.getAttrs(entity.getPlainAttrsJSON()).stream().filter(PlainAttr::isValid).peek(attr -> {
                attr.getValues().forEach(value -> value.setAttr(attr));
                Optional.ofNullable(attr.getUniqueValue()).ifPresent(value -> value.setAttr(attr));
            }).forEach(attr -> entity.add((PlainAttr)attr));
        }
    }
}

