/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractProvisioningTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTaskExec;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="PushTask")
public class JPAPushTask
extends AbstractProvisioningTask<PushTask>
implements PushTask {
    private static final long serialVersionUID = -4141057723006682564L;
    public static final String TABLE = "PushTask";
    protected static final TypeReference<HashMap<String, String>> FILTER_TYPEREF = new TypeReference<HashMap<String, String>>(){};
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private JPARealm sourceRealm;
    @Lob
    private String filters;
    @Transient
    private Map<String, String> filterMap = new HashMap<String, String>();
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="PushTaskAction", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"task_id", "implementation_id"})})
    private List<JPAImplementation> actions = new ArrayList<JPAImplementation>();
    @OneToMany(targetEntity=JPAPushTaskExec.class, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="task")
    private List<TaskExec<SchedTask>> executions = new ArrayList<TaskExec<SchedTask>>();
    private static int pcInheritedFieldCount = AbstractProvisioningTask.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public JPARealm getSourceRealm() {
        return JPAPushTask.pcGetsourceRealm(this);
    }

    public void setSourceRealm(Realm sourceRealm) {
        this.checkType(sourceRealm, JPARealm.class);
        JPAPushTask.pcSetsourceRealm(this, (JPARealm)sourceRealm);
    }

    public boolean add(Implementation action) {
        this.checkType(action, JPAImplementation.class);
        this.checkImplementationType(action, "PUSH_ACTIONS");
        return JPAPushTask.pcGetactions(this).contains((JPAImplementation)action) || JPAPushTask.pcGetactions(this).add((JPAImplementation)action);
    }

    public List<? extends Implementation> getActions() {
        return JPAPushTask.pcGetactions(this);
    }

    public Optional<String> getFilter(String anyType) {
        return Optional.ofNullable(this.filterMap.get(anyType));
    }

    public Map<String, String> getFilters() {
        return this.filterMap;
    }

    @Override
    protected Class<? extends TaskExec<SchedTask>> executionClass() {
        return JPAPushTaskExec.class;
    }

    @Override
    protected List<TaskExec<SchedTask>> executions() {
        return JPAPushTask.pcGetexecutions(this);
    }

    protected void json2map(boolean clearFirst) {
        if (clearFirst) {
            this.getFilters().clear();
        }
        if (JPAPushTask.pcGetfilters(this) != null) {
            this.getFilters().putAll((Map)POJOHelper.deserialize((String)JPAPushTask.pcGetfilters(this), FILTER_TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2map(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2map(true);
    }

    @PrePersist
    @PreUpdate
    public void map2json() {
        JPAPushTask.pcSetfilters(this, POJOHelper.serialize(this.getFilters()));
    }

    static {
        pcPCSuperclass = AbstractProvisioningTask.class;
        pcFieldNames = new String[]{"actions", "executions", "filters", "sourceRealm"};
        pcFieldTypes = new Class[]{List.class, List.class, String.class, JPARealm.class};
        pcFieldFlags = new byte[]{10, 5, 26, 26};
        PCRegistry.register(JPAPushTask.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAPushTask", (PersistenceCapable)new JPAPushTask());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.actions = null;
        this.executions = null;
        this.filters = null;
        this.sourceRealm = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAPushTask jPAPushTask = new JPAPushTask();
        if (bl) {
            jPAPushTask.pcClearFields();
        }
        jPAPushTask.pcStateManager = stateManager;
        jPAPushTask.pcCopyKeyFieldsFromObjectId(object);
        return jPAPushTask;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAPushTask jPAPushTask = new JPAPushTask();
        if (bl) {
            jPAPushTask.pcClearFields();
        }
        jPAPushTask.pcStateManager = stateManager;
        return jPAPushTask;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + AbstractProvisioningTask.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.executions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.filters = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.sourceRealm = (JPARealm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.actions);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.executions);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.filters);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.sourceRealm);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAPushTask jPAPushTask, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAPushTask, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = jPAPushTask.actions;
                return;
            }
            case 1: {
                this.executions = jPAPushTask.executions;
                return;
            }
            case 2: {
                this.filters = jPAPushTask.filters;
                return;
            }
            case 3: {
                this.sourceRealm = jPAPushTask.sourceRealm;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAPushTask jPAPushTask = (JPAPushTask)object;
        if (jPAPushTask.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAPushTask, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAPushTask.class;
    }

    private static final List pcGetactions(JPAPushTask jPAPushTask) {
        if (jPAPushTask.pcStateManager == null) {
            return jPAPushTask.actions;
        }
        int n = pcInheritedFieldCount + 0;
        jPAPushTask.pcStateManager.accessingField(n);
        return jPAPushTask.actions;
    }

    private static final void pcSetactions(JPAPushTask jPAPushTask, List list) {
        if (jPAPushTask.pcStateManager == null) {
            jPAPushTask.actions = list;
            return;
        }
        jPAPushTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPushTask, pcInheritedFieldCount + 0, jPAPushTask.actions, (Object)list, 0);
    }

    private static final List pcGetexecutions(JPAPushTask jPAPushTask) {
        if (jPAPushTask.pcStateManager == null) {
            return jPAPushTask.executions;
        }
        int n = pcInheritedFieldCount + 1;
        jPAPushTask.pcStateManager.accessingField(n);
        return jPAPushTask.executions;
    }

    private static final void pcSetexecutions(JPAPushTask jPAPushTask, List list) {
        if (jPAPushTask.pcStateManager == null) {
            jPAPushTask.executions = list;
            return;
        }
        jPAPushTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPushTask, pcInheritedFieldCount + 1, jPAPushTask.executions, (Object)list, 0);
    }

    private static final String pcGetfilters(JPAPushTask jPAPushTask) {
        if (jPAPushTask.pcStateManager == null) {
            return jPAPushTask.filters;
        }
        int n = pcInheritedFieldCount + 2;
        jPAPushTask.pcStateManager.accessingField(n);
        return jPAPushTask.filters;
    }

    private static final void pcSetfilters(JPAPushTask jPAPushTask, String string) {
        if (jPAPushTask.pcStateManager == null) {
            jPAPushTask.filters = string;
            return;
        }
        jPAPushTask.pcStateManager.settingStringField((PersistenceCapable)jPAPushTask, pcInheritedFieldCount + 2, jPAPushTask.filters, string, 0);
    }

    private static final JPARealm pcGetsourceRealm(JPAPushTask jPAPushTask) {
        if (jPAPushTask.pcStateManager == null) {
            return jPAPushTask.sourceRealm;
        }
        int n = pcInheritedFieldCount + 3;
        jPAPushTask.pcStateManager.accessingField(n);
        return jPAPushTask.sourceRealm;
    }

    private static final void pcSetsourceRealm(JPAPushTask jPAPushTask, JPARealm jPARealm) {
        if (jPAPushTask.pcStateManager == null) {
            jPAPushTask.sourceRealm = jPARealm;
            return;
        }
        jPAPushTask.pcStateManager.settingObjectField((PersistenceCapable)jPAPushTask, pcInheritedFieldCount + 3, (Object)jPAPushTask.sourceRealm, (Object)jPARealm, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

