/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.jdbc.IsolationLevel;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class OpenJpaDialect
extends DefaultJpaDialect {
    private static final long serialVersionUID = 2099118508988476959L;

    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, TransactionException {
        FetchPlan fetchPlan;
        OpenJPAEntityManager openJpaEntityManager = OpenJpaDialect.getOpenJPAEntityManager(entityManager);
        if (definition.getIsolationLevel() != -1 && (fetchPlan = openJpaEntityManager.getFetchPlan()) instanceof JDBCFetchPlan) {
            JDBCFetchPlan jDBCFetchPlan = (JDBCFetchPlan)fetchPlan;
            IsolationLevel isolation = IsolationLevel.fromConnectionConstant((int)definition.getIsolationLevel());
            jDBCFetchPlan.setIsolation(isolation);
        }
        entityManager.getTransaction().begin();
        if (!definition.isReadOnly()) {
            openJpaEntityManager.beginStore();
        }
        return new OpenJpaTransactionData(openJpaEntityManager);
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException {
        return new OpenJpaConnectionHandle(OpenJpaDialect.getOpenJPAEntityManager(entityManager));
    }

    protected static OpenJPAEntityManager getOpenJPAEntityManager(EntityManager em) {
        return OpenJPAPersistence.cast((EntityManager)em);
    }

    private static class OpenJpaTransactionData
    implements SavepointManager {
        private final OpenJPAEntityManager entityManager;
        private int savepointCounter = 0;

        OpenJpaTransactionData(OpenJPAEntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Object createSavepoint() throws TransactionException {
            ++this.savepointCounter;
            String savepointName = "SAVEPOINT_" + this.savepointCounter;
            this.entityManager.setSavepoint(savepointName);
            return savepointName;
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.entityManager.rollbackToSavepoint((String)savepoint);
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            try {
                this.entityManager.releaseSavepoint((String)savepoint);
            }
            catch (Throwable ex) {
                LogFactory.getLog(OpenJpaTransactionData.class).debug((Object)"Could not explicitly release OpenJPA savepoint", ex);
            }
        }
    }

    private static class OpenJpaConnectionHandle
    implements ConnectionHandle {
        private final OpenJPAEntityManager entityManager;

        OpenJpaConnectionHandle(OpenJPAEntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Connection getConnection() {
            return (Connection)this.entityManager.getConnection();
        }

        public void releaseConnection(Connection con) {
            JdbcUtils.closeConnection((Connection)con);
        }
    }
}

