/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk;

import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.clients.WavefrontClient;
import com.wavefront.sdk.common.clients.WavefrontClientFactory;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.proxy.WavefrontProxyClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

public class Main {
    private static void sendMetric(WavefrontSender wavefrontSender) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("datacenter", "dc1");
            }
        };
        wavefrontSender.sendMetric("new-york.power.usage", 42422.0, null, "localhost", (Map<String, String>)tags);
        System.out.println("Sent metric: 'new-york.power.usage'");
    }

    private static void sendDeltaCounter(WavefrontSender wavefrontSender) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("image-format", "jpeg");
            }
        };
        wavefrontSender.sendDeltaCounter("lambda.thumbnail.generate", 10.0, "lambda_thumbnail_service", (Map<String, String>)tags);
        System.out.println("Sent metric: 'lambda.thumbnail.generate'");
    }

    private static void sendHistogram(WavefrontSender wavefrontSender) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>(){
            {
                this.put("region", "us-west");
            }
        };
        HashSet<HistogramGranularity> histogramGranularities = new HashSet<HistogramGranularity>();
        histogramGranularities.add(HistogramGranularity.MINUTE);
        histogramGranularities.add(HistogramGranularity.HOUR);
        histogramGranularities.add(HistogramGranularity.DAY);
        wavefrontSender.sendDistribution("request.latency", Arrays.asList(new Pair<Double, Integer>(30.0, 20), new Pair<Double, Integer>(5.1, 10)), histogramGranularities, null, "appServer1", (Map<String, String>)tags);
        System.out.println("Sent histogram: 'request.latency'");
    }

    private static void sendTracingSpan(WavefrontSender wavefrontSender) throws IOException {
        wavefrontSender.sendSpan("getAllUsers", 1533529977L, 343500L, "localhost", UUID.fromString("7b3bf470-9456-11e8-9eb6-529269fb1459"), UUID.fromString("0313bafe-9457-11e8-9eb6-529269fb1459"), Arrays.asList(UUID.fromString("2f64e538-9457-11e8-9eb6-529269fb1459")), null, Arrays.asList(new Pair<String, String>("application", "Wavefront"), new Pair<String, String>("service", "test-spans"), new Pair<String, String>("http.method", "GET")), null);
        System.out.println("Sent tracing span: 'getAllUsers'");
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String wavefrontServer = args[0];
        String token = args[1];
        String proxyHost = args.length < 3 ? null : args[2];
        String metricsPort = args.length < 4 ? null : args[3];
        String distributionPort = args.length < 5 ? null : args[4];
        String tracingPort = args.length < 6 ? null : args[5];
        String wavefrontProxyWithPort = args.length < 7 ? null : args[6];
        String wavefrontServerWithToken = wavefrontServer.substring(0, wavefrontServer.indexOf("://") + 3) + token + "@" + wavefrontServer.substring(wavefrontServer.indexOf("://") + 3);
        System.out.println("wavefrontServerWithToken = " + wavefrontServerWithToken);
        WavefrontClient.Builder wfClientBuilder = new WavefrontClient.Builder(wavefrontServer, token);
        WavefrontClient wavefrontSender = wfClientBuilder.build();
        WavefrontClientFactory wavefrontClientFactory = new WavefrontClientFactory();
        wavefrontClientFactory.addClient(wavefrontSender);
        if (proxyHost != null) {
            WavefrontProxyClient.Builder builder = new WavefrontProxyClient.Builder(proxyHost);
            if (metricsPort != null) {
                builder.metricsPort(Integer.parseInt(metricsPort));
            }
            if (distributionPort != null) {
                builder.distributionPort(Integer.parseInt(distributionPort));
            }
            if (tracingPort != null) {
                builder.tracingPort(Integer.parseInt(tracingPort));
            }
            WavefrontProxyClient wavefrontProxyClient = builder.build();
            wavefrontClientFactory.addClient(wavefrontProxyClient);
        }
        if (wavefrontProxyWithPort != null) {
            wavefrontClientFactory.addClient(wavefrontProxyWithPort);
        }
        WavefrontSender wavefrontClient = wavefrontClientFactory.getClient();
        while (true) {
            Main.sendMetric(wavefrontClient);
            Main.sendDeltaCounter(wavefrontClient);
            Main.sendHistogram(wavefrontClient);
            Main.sendTracingSpan(wavefrontClient);
            wavefrontClient.flush();
            Thread.sleep(5000L);
        }
    }
}

