/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.DiscoverConfigurationApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.LiveSyncApiOp;
import org.identityconnectors.framework.api.operations.ResolveUsernameApiOp;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.api.operations.UpdateDeltaApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.AbstractConnectorFacade;
import org.identityconnectors.framework.impl.api.LoggingProxy;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.operations.AuthenticationImpl;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunnerProxy;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.CreateImpl;
import org.identityconnectors.framework.impl.api.local.operations.DeleteImpl;
import org.identityconnectors.framework.impl.api.local.operations.DiscoverConfigurationImpl;
import org.identityconnectors.framework.impl.api.local.operations.GetImpl;
import org.identityconnectors.framework.impl.api.local.operations.LiveSyncImpl;
import org.identityconnectors.framework.impl.api.local.operations.OperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.ResolveUsernameImpl;
import org.identityconnectors.framework.impl.api.local.operations.SchemaImpl;
import org.identityconnectors.framework.impl.api.local.operations.ScriptOnConnectorImpl;
import org.identityconnectors.framework.impl.api.local.operations.ScriptOnResourceImpl;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.impl.api.local.operations.SyncImpl;
import org.identityconnectors.framework.impl.api.local.operations.TestImpl;
import org.identityconnectors.framework.impl.api.local.operations.ThreadClassLoaderManagerProxy;
import org.identityconnectors.framework.impl.api.local.operations.UpdateDeltaImpl;
import org.identityconnectors.framework.impl.api.local.operations.UpdateImpl;
import org.identityconnectors.framework.impl.api.local.operations.ValidateImpl;
import org.identityconnectors.framework.spi.Connector;

public class LocalConnectorFacadeImpl
extends AbstractConnectorFacade {
    private static final Map<Class<? extends APIOperation>, Constructor<? extends ConnectorAPIOperationRunner>> API_TO_IMPL = new HashMap<Class<? extends APIOperation>, Constructor<? extends ConnectorAPIOperationRunner>>();
    private final LocalConnectorInfoImpl connectorInfo;
    private final ConnectorOperationalContext operationalContext;

    private static void addImplementation(Class<? extends APIOperation> inter, Class<? extends ConnectorAPIOperationRunner> impl) {
        try {
            Constructor<? extends ConnectorAPIOperationRunner> constructor = impl.getConstructor(ConnectorOperationalContext.class, Connector.class);
            API_TO_IMPL.put(inter, constructor);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public LocalConnectorFacadeImpl(LocalConnectorInfoImpl connectorInfo, APIConfigurationImpl apiConfiguration) {
        super(apiConfiguration);
        this.connectorInfo = connectorInfo;
        this.operationalContext = connectorInfo.isConfigurationStateless() && !connectorInfo.isConnectorPoolingSupported() ? null : new ConnectorOperationalContext(connectorInfo, this.getAPIConfiguration());
    }

    public LocalConnectorFacadeImpl(LocalConnectorInfoImpl connectorInfo, String configuration) {
        super(configuration, connectorInfo);
        this.connectorInfo = connectorInfo;
        this.operationalContext = connectorInfo.isConfigurationStateless() && !connectorInfo.isConnectorPoolingSupported() ? null : new ConnectorOperationalContext(connectorInfo, this.getAPIConfiguration());
    }

    public void dispose() {
        if (null != this.operationalContext) {
            this.operationalContext.dispose();
        }
    }

    protected ConnectorOperationalContext getOperationalContext() {
        if (null == this.operationalContext) {
            return new ConnectorOperationalContext(this.connectorInfo, this.getAPIConfiguration());
        }
        return this.operationalContext;
    }

    @Override
    protected APIOperation getOperationImplementation(Class<? extends APIOperation> api) {
        Object proxy;
        if (api == ValidateApiOp.class) {
            OperationalContext context = new OperationalContext(this.connectorInfo, this.getAPIConfiguration());
            proxy = new ValidateImpl(context);
        } else if (api == GetApiOp.class) {
            Constructor<? extends ConnectorAPIOperationRunner> constructor = API_TO_IMPL.get(SearchApiOp.class);
            ConnectorAPIOperationRunnerProxy handler = new ConnectorAPIOperationRunnerProxy(this.getOperationalContext(), constructor);
            proxy = new GetImpl((SearchApiOp)this.newAPIOperationProxy(SearchApiOp.class, handler));
        } else {
            Constructor<? extends ConnectorAPIOperationRunner> constructor = API_TO_IMPL.get(api);
            ConnectorAPIOperationRunnerProxy handler = new ConnectorAPIOperationRunnerProxy(this.getOperationalContext(), constructor);
            proxy = this.newAPIOperationProxy(api, handler);
        }
        proxy = this.newAPIOperationProxy(api, new ThreadClassLoaderManagerProxy(this.connectorInfo.getConnectorClass().getClassLoader(), proxy));
        proxy = this.createTimeoutProxy(api, (APIOperation)proxy);
        if (LoggingProxy.isLoggable()) {
            proxy = this.createLoggingProxy(api, (APIOperation)proxy);
        }
        return proxy;
    }

    static {
        LocalConnectorFacadeImpl.addImplementation(CreateApiOp.class, CreateImpl.class);
        LocalConnectorFacadeImpl.addImplementation(DeleteApiOp.class, DeleteImpl.class);
        LocalConnectorFacadeImpl.addImplementation(SchemaApiOp.class, SchemaImpl.class);
        LocalConnectorFacadeImpl.addImplementation(SearchApiOp.class, SearchImpl.class);
        LocalConnectorFacadeImpl.addImplementation(UpdateApiOp.class, UpdateImpl.class);
        LocalConnectorFacadeImpl.addImplementation(UpdateDeltaApiOp.class, UpdateDeltaImpl.class);
        LocalConnectorFacadeImpl.addImplementation(AuthenticationApiOp.class, AuthenticationImpl.class);
        LocalConnectorFacadeImpl.addImplementation(ResolveUsernameApiOp.class, ResolveUsernameImpl.class);
        LocalConnectorFacadeImpl.addImplementation(TestApiOp.class, TestImpl.class);
        LocalConnectorFacadeImpl.addImplementation(ScriptOnConnectorApiOp.class, ScriptOnConnectorImpl.class);
        LocalConnectorFacadeImpl.addImplementation(ScriptOnResourceApiOp.class, ScriptOnResourceImpl.class);
        LocalConnectorFacadeImpl.addImplementation(SyncApiOp.class, SyncImpl.class);
        LocalConnectorFacadeImpl.addImplementation(LiveSyncApiOp.class, LiveSyncImpl.class);
        LocalConnectorFacadeImpl.addImplementation(DiscoverConfigurationApiOp.class, DiscoverConfigurationImpl.class);
    }
}

