/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.common.engine.impl.variable.NoopVariableLengthVerifier;
import org.flowable.common.engine.impl.variable.VariableLengthVerifier;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class ByteArrayType
implements VariableType {
    public static final String TYPE_NAME = "bytes";
    private static final long serialVersionUID = 1L;
    protected final VariableLengthVerifier lengthVerifier;

    public ByteArrayType() {
        this(NoopVariableLengthVerifier.INSTANCE);
    }

    public ByteArrayType(VariableLengthVerifier lengthVerifier) {
        this.lengthVerifier = lengthVerifier != null ? lengthVerifier : NoopVariableLengthVerifier.INSTANCE;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        return valueFields.getBytes();
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value == null) {
            valueFields.setBytes(null);
            return;
        }
        byte[] bytes = (byte[])value;
        this.lengthVerifier.verifyLength(bytes.length, valueFields, (VariableType)this);
        valueFields.setBytes((byte[])value);
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return byte[].class.isAssignableFrom(value.getClass());
    }
}

