/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ConfirmLogoutAction
extends AbstractLogoutAction {
    public ConfirmLogoutAction(TicketRegistry ticketRegistry, CasCookieBuilder ticketGrantingTicketCookieGenerator, ArgumentExtractor argumentExtractor, ServicesManager servicesManager, LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
        super(ticketRegistry, ticketGrantingTicketCookieGenerator, argumentExtractor, servicesManager, logoutExecutionPlan, casProperties);
    }

    @Override
    protected Event doInternalExecute(RequestContext requestContext) {
        String tgtId = this.getTicketGrantingTicket(requestContext);
        if (StringUtils.isNotBlank((CharSequence)tgtId)) {
            TicketGrantingTicket ticket = (TicketGrantingTicket)this.ticketRegistry.getTicket(tgtId, TicketGrantingTicket.class);
            WebUtils.putAuthentication((Authentication)ticket.getAuthentication(), (RequestContext)requestContext);
            WebUtils.putTicketGrantingTicket((RequestContext)requestContext, (Ticket)ticket);
        }
        return this.success();
    }

    private String getTicketGrantingTicket(RequestContext context) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            return this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        return tgtId;
    }
}

