/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.io;

import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.io.Resource;

public abstract class AbstractResource
implements Resource {
    private final String location;

    public AbstractResource(String location) {
        Assert.hasText((String)location, (String)"Location argument cannot be null or empty.");
        this.location = this.canonicalize(location);
    }

    protected String canonicalize(String input) {
        if (this.hasResourcePrefix(input)) {
            input = AbstractResource.stripPrefix(input);
        }
        return input;
    }

    protected boolean hasResourcePrefix(String resourcePath) {
        return resourcePath != null && resourcePath.startsWith(this.getScheme() + ":");
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(":") + 1);
    }

    public String getLocation() {
        return this.location;
    }

    protected abstract String getScheme();

    public String toString() {
        return this.getScheme() + this.location;
    }
}

