/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.common.clients.service.token.TokenService;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.wavefront.WavefrontMeterRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Function;

public interface WavefrontConfig
extends PushRegistryConfig {
    public static final WavefrontConfig DEFAULT_PROXY = new WavefrontConfig(){

        public String get(String key) {
            return null;
        }

        @Override
        public String uri() {
            String v = this.get(this.prefix() + ".uri");
            return v == null ? "proxy://localhost:2878" : v;
        }
    };
    public static final WavefrontConfig DEFAULT_DIRECT = new WavefrontConfig(){

        public String get(String key) {
            return null;
        }

        @Override
        public String uri() {
            String v = this.get(this.prefix() + ".uri");
            return v == null ? "https://longboard.wavefront.com" : v;
        }
    };

    default public String prefix() {
        return "wavefront";
    }

    default public String uri() {
        return (String)PropertyValidator.getUriString((MeterRegistryConfig)this, (String)"uri").required().get();
    }

    @Deprecated
    default public int distributionPort() {
        return -1;
    }

    default public String source() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"source").orElseGet(() -> {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                return "unknown";
            }
        });
    }

    default public TokenService.Type apiTokenType() {
        return (TokenService.Type)PropertyValidator.getEnum((MeterRegistryConfig)this, TokenService.Type.class, (String)"apiTokenType").invalidateWhen(tokenType -> tokenType == TokenService.Type.NO_TOKEN && WavefrontMeterRegistry.isDirectToApi(this), "must be set to something else whenever publishing directly to the Wavefront API", InvalidReason.MISSING).orElse((Object)(WavefrontMeterRegistry.isDirectToApi(this) ? TokenService.Type.WAVEFRONT_API_TOKEN : TokenService.Type.NO_TOKEN));
    }

    @Nullable
    default public String apiToken() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"apiToken").invalidateWhen(token -> token == null && WavefrontMeterRegistry.isDirectToApi(this), "must be set whenever publishing directly to the Wavefront API", InvalidReason.MISSING).orElse(null);
    }

    default public boolean reportMinuteDistribution() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"reportMinuteDistribution").orElse((Object)true);
    }

    default public boolean reportHourDistribution() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"reportHourDistribution").orElse((Object)false);
    }

    default public boolean reportDayDistribution() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"reportDayDistribution").orElse((Object)false);
    }

    @Nullable
    default public String globalPrefix() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"globalPrefix").orElse(null);
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> PushRegistryConfig.validate((PushRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"source", WavefrontConfig::source)});
    }

    default public Validated<?> validateSenderConfiguration() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> this.validate(), MeterRegistryConfigValidator.checkRequired((String)"uri", WavefrontConfig::uri), MeterRegistryConfigValidator.check((String)"apiToken", WavefrontConfig::apiToken).andThen(v -> v.invalidateWhen(token -> token == null && WavefrontMeterRegistry.isDirectToApi(this), "must be set whenever publishing directly to the Wavefront API", InvalidReason.MISSING))});
    }
}

