/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import java.util.regex.Pattern;

public class WavefrontNamingConvention
implements NamingConvention {
    private static final Pattern NAME_CLEANUP_PATTERN = Pattern.compile("[^a-zA-Z0-9\\-_\\./,]");
    private static final Pattern KEY_CLEANUP_PATTERN = Pattern.compile("[^a-zA-Z0-9\\-_\\.]");
    private final NamingConvention delegate;
    @Nullable
    private String namePrefix;

    public WavefrontNamingConvention(@Nullable String namePrefix) {
        this(namePrefix, NamingConvention.dot);
    }

    public WavefrontNamingConvention(@Nullable String namePrefix, NamingConvention delegate) {
        this.delegate = delegate;
        this.namePrefix = namePrefix != null && namePrefix.isEmpty() ? null : namePrefix;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String sanitizedName = NAME_CLEANUP_PATTERN.matcher(this.delegate.name(name, type, baseUnit)).replaceAll("_");
        if (this.namePrefix != null) {
            return this.namePrefix + "." + sanitizedName;
        }
        return sanitizedName;
    }

    public String tagKey(String key) {
        return KEY_CLEANUP_PATTERN.matcher(this.delegate.tagKey(key)).replaceAll("_");
    }

    public String tagValue(String value) {
        String sanitized = this.delegate.tagValue(value);
        return StringEscapeUtils.escapeJson((String)(sanitized.endsWith("\\") ? sanitized.substring(0, sanitized.length() - 1) + "_" : sanitized));
    }
}

