/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;

public class IntermediateCatchEventRegistryEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String eventDefinitionKey;

    public IntermediateCatchEventRegistryEventActivityBehavior(String eventDefinitionKey) {
        this.eventDefinitionKey = eventDefinitionKey;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        String eventDefinitionKey = this.getEventDefinitionKey(commandContext, executionEntity);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionEntity eventSubscription = (EventSubscriptionEntity)processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().createEventSubscriptionBuilder().eventType(eventDefinitionKey).executionId(executionEntity.getId()).processInstanceId(executionEntity.getProcessInstanceId()).activityId(executionEntity.getCurrentActivityId()).processDefinitionId(executionEntity.getProcessDefinitionId()).scopeType("bpmn").tenantId(executionEntity.getTenantId()).configuration(CorrelationUtil.getCorrelationKey("eventCorrelationParameter", commandContext, executionEntity)).create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        executionEntity.getEventSubscriptions().add(eventSubscription);
    }

    protected String getEventDefinitionKey(CommandContext commandContext, ExecutionEntity executionEntity) {
        Object key = null;
        if (StringUtils.isNotEmpty((CharSequence)this.eventDefinitionKey)) {
            Expression expression = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager().createExpression(this.eventDefinitionKey);
            key = expression.getValue((VariableContainer)executionEntity);
        }
        if (key == null) {
            throw new FlowableException("Could not resolve key for: " + this.eventDefinitionKey + " in " + String.valueOf(executionEntity));
        }
        return key.toString();
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = this.deleteEventSubscription(execution);
        this.leaveIntermediateCatchEvent(executionEntity);
    }

    @Override
    public void eventCancelledByEventGateway(DelegateExecution execution) {
        this.deleteEventSubscription(execution);
        CommandContextUtil.getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, "event based gateway cancel", false);
    }

    protected ExecutionEntity deleteEventSubscription(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        Object eventInstance = execution.getTransientVariables().get("eventInstance");
        if (eventInstance instanceof EventInstance) {
            EventInstanceBpmnUtil.handleEventInstanceOutParameters(execution, (BaseElement)execution.getCurrentFlowElement(), (EventInstance)eventInstance);
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        List<EventSubscriptionEntity> eventSubscriptions = executionEntity.getEventSubscriptions();
        String eventDefinitionKey = this.getEventDefinitionKey(commandContext, executionEntity);
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            if (!Objects.equals(eventDefinitionKey, eventSubscription.getEventType())) continue;
            eventSubscriptionService.deleteEventSubscription(eventSubscription);
            CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscription);
        }
        return executionEntity;
    }
}

