/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClasspathResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResourceMetadataResolver.class);

    public ClasspathResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    @Audit(action="SAML2_METADATA_RESOLUTION", actionResolverName="SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", resourceResolverName="SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER")
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        List list;
        block8: {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
            InputStream in = ResourceUtils.getResourceFrom((String)metadataLocation).getInputStream();
            try {
                LOGGER.debug("Parsing metadata from [{}]", (Object)metadataLocation);
                Document document = this.configBean.getParserPool().parse(in);
                Element metadataRoot = document.getDocumentElement();
                DOMMetadataResolver metadataProvider = new DOMMetadataResolver(metadataRoot);
                metadataProvider.setResolveViaPredicatesOnly(true);
                this.configureAndInitializeSingleMetadataResolver((AbstractMetadataResolver)metadataProvider, service);
                list = CollectionUtils.wrap((Object)metadataProvider);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                    return new ArrayList();
                }
            }
            in.close();
        }
        return list;
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        try {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
            return metadataResource instanceof ClassPathResource;
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        return this.supports(service);
    }
}

