/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.policy;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.provisioning.api.rules.PasswordRuleConfClass;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.IllegalCharacterRule;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;
import org.passay.RepeatCharactersRule;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.UsernameRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@PasswordRuleConfClass(value=DefaultPasswordRuleConf.class)
public class DefaultPasswordRule
implements PasswordRule {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultPasswordRule.class);
    @Autowired
    protected EncryptorManager encryptorManager;
    protected DefaultPasswordRuleConf conf;
    protected PasswordValidator passwordValidator;

    public static List<Rule> conf2Rules(final DefaultPasswordRuleConf conf) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        LengthRule lengthRule = new LengthRule();
        if (conf.getMinLength() > 0) {
            lengthRule.setMinimumLength(conf.getMinLength());
        }
        if (conf.getMaxLength() > 0) {
            lengthRule.setMaximumLength(conf.getMaxLength());
        }
        rules.add((Rule)lengthRule);
        if (conf.getAlphabetical() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.Alphabetical, conf.getAlphabetical()));
        }
        if (conf.getUppercase() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, conf.getUppercase()));
        }
        if (conf.getLowercase() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, conf.getLowercase()));
        }
        if (conf.getDigit() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.Digit, conf.getDigit()));
        }
        if (conf.getSpecial() > 0) {
            rules.add((Rule)new CharacterRule(new CharacterData(){

                public String getErrorCode() {
                    return "INSUFFICIENT_SPECIAL";
                }

                public String getCharacters() {
                    return new String(ArrayUtils.toPrimitive((Character[])((Character[])conf.getSpecialChars().toArray(Character[]::new))));
                }
            }, conf.getSpecial()));
        }
        if (!conf.getIllegalChars().isEmpty()) {
            rules.add((Rule)new IllegalCharacterRule(ArrayUtils.toPrimitive((Character[])((Character[])conf.getIllegalChars().toArray(Character[]::new)))));
        }
        if (conf.getRepeatSame() > 0) {
            rules.add((Rule)new RepeatCharactersRule(conf.getRepeatSame()));
        }
        if (!conf.isUsernameAllowed()) {
            rules.add((Rule)new UsernameRule(true, true));
        }
        return rules;
    }

    public PasswordRuleConf getConf() {
        return this.conf;
    }

    public void setConf(PasswordRuleConf conf) {
        block9: {
            if (conf instanceof DefaultPasswordRuleConf) {
                DefaultPasswordRuleConf defaultPasswordRuleConf;
                this.conf = defaultPasswordRuleConf = (DefaultPasswordRuleConf)conf;
                Properties passay = new Properties();
                try (InputStream in = this.getClass().getResourceAsStream("/passay.properties");){
                    passay.load(in);
                    this.passwordValidator = new PasswordValidator((MessageResolver)new PropertiesMessageResolver(passay), DefaultPasswordRule.conf2Rules(this.conf));
                    break block9;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not initialize Passay", e);
                }
            }
            throw new IllegalArgumentException(DefaultPasswordRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
    }

    protected void enforce(String clear, String username, Set<String> wordsNotPermitted) {
        RuleResult result = this.passwordValidator.validate(username == null ? new PasswordData(clear) : new PasswordData(username, clear));
        if (!result.isValid()) {
            throw new PasswordPolicyException(String.join((CharSequence)",", this.passwordValidator.getMessages(result)));
        }
        wordsNotPermitted.stream().filter(word -> Strings.CI.contains((CharSequence)clear, (CharSequence)word)).findFirst().ifPresent(word -> {
            throw new PasswordPolicyException("Used word(s) not permitted");
        });
    }

    public void enforce(String username, String clearPassword) {
        if (clearPassword != null) {
            HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
            this.enforce(clearPassword, username, wordsNotPermitted);
        }
    }

    @Transactional(readOnly=true)
    public void enforce(User user, String clearPassword) {
        if (clearPassword != null) {
            HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
            wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(schema -> user.getPlainAttr(schema).map(PlainAttr::getValuesAsStrings).orElse(null)).filter(Objects::nonNull).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
            this.enforce(clearPassword, user.getUsername(), wordsNotPermitted);
        }
    }

    @Transactional(readOnly=true)
    public void enforce(LinkedAccount account) {
        this.conf.getWordsNotPermitted().addAll(this.conf.getSchemasNotPermitted().stream().map(schema -> account.getPlainAttr(schema).map(PlainAttr::getValuesAsStrings).orElse(null)).filter(Objects::nonNull).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).toList());
        if (account.getPassword() != null) {
            String clear = null;
            if (account.canDecodeSecrets()) {
                try {
                    clear = this.encryptorManager.getInstance().decode(account.getPassword(), account.getCipherAlgorithm());
                }
                catch (Exception e) {
                    LOG.error("Could not decode password for {}", (Object)account, (Object)e);
                }
            }
            if (clear != null) {
                HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
                wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(schema -> account.getPlainAttr(schema).map(PlainAttr::getValuesAsStrings).orElse(null)).filter(Objects::nonNull).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
                this.enforce(clear, account.getUsername(), wordsNotPermitted);
            }
        }
    }
}

