/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.attribute;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.lang.reflect.Field;

public class ReflectiveAttribute<O, A>
extends SimpleAttribute<O, A> {
    final Field field;

    public ReflectiveAttribute(Class<O> objectType, Class<A> fieldType, String fieldName) {
        super(objectType, fieldType, fieldName);
        Field field;
        try {
            field = ReflectiveAttribute.getField(objectType, fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid attribute definition: No such field '" + fieldName + "' in object '" + objectType.getName() + "'");
        }
        if (!fieldType.isAssignableFrom(field.getType())) {
            throw new IllegalStateException("Invalid attribute definition: The type of field '" + fieldName + "', type '" + field.getType() + "', in object '" + objectType.getName() + "', is not assignable to the type indicated: " + fieldType.getName());
        }
        this.field = field;
    }

    static Field getField(Class<?> cls, String fieldName) throws NoSuchFieldException {
        while (cls != null && cls != Object.class) {
            try {
                return cls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
        }
        throw new NoSuchFieldException("No such field: " + fieldName);
    }

    @Override
    public A getValue(O object, QueryOptions queryOptions) {
        try {
            Object value = this.field.get(object);
            return (A)value;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read value from field '" + this.field.getName() + "'", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReflectiveAttribute)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReflectiveAttribute that = (ReflectiveAttribute)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return this.field.equals(that.field);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof ReflectiveAttribute;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public static <O, A> ReflectiveAttribute<O, A> forField(Class<O> objectType, Class<A> fieldType, String fieldName) {
        return new ReflectiveAttribute<O, A>(objectType, fieldType, fieldName);
    }
}

