/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.time.Duration;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.scripting.DefaultScriptTrace;
import org.flowable.common.engine.impl.scripting.FlowableScriptEngine;
import org.flowable.common.engine.impl.scripting.FlowableScriptEvaluationException;
import org.flowable.common.engine.impl.scripting.FlowableScriptEvaluationRequest;
import org.flowable.common.engine.impl.scripting.FlowableScriptException;
import org.flowable.common.engine.impl.scripting.ScriptBindingsFactory;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptEvaluation;
import org.flowable.common.engine.impl.scripting.ScriptTrace;
import org.flowable.common.engine.impl.scripting.ScriptTraceEnhancer;
import org.flowable.common.engine.impl.scripting.ScriptTraceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingEngines.class);
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    public static final String GROOVY_SCRIPTING_LANGUAGE = "groovy";
    protected final FlowableScriptEngine scriptEngine;
    protected ScriptBindingsFactory scriptBindingsFactory;
    protected ScriptTraceEnhancer defaultTraceEnhancer;
    protected ScriptTraceListener scriptErrorListener = null;
    protected ScriptTraceListener scriptSuccessListener = null;

    public ScriptingEngines(FlowableScriptEngine scriptEngine, ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptEngine = scriptEngine;
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptEvaluation evaluate(ScriptEngineRequest request) {
        FlowableScriptEvaluationRequest evaluationRequest = this.scriptEngine.createEvaluationRequest().language(request.getLanguage()).script(request.getScript()).scopeContainer(request.getScopeContainer()).inputVariableContainer(request.getInputVariableContainer()).resolver(this.getScriptBindingsFactory().createResolver(request));
        if (request.isStoreScriptVariables()) {
            evaluationRequest.storeScriptVariables();
        }
        long startNanos = System.nanoTime();
        try {
            ScriptEvaluation evaluationResult = evaluationRequest.evaluate();
            if (this.scriptSuccessListener != null) {
                DefaultScriptTrace scriptTrace = DefaultScriptTrace.successTrace(Duration.ofNanos(System.nanoTime() - startNanos), request);
                this.enhanceScriptTrace(request, scriptTrace);
                this.notifyScriptTraceListener(this.scriptSuccessListener, scriptTrace);
            }
            return evaluationResult;
        }
        catch (FlowableScriptException e) {
            Throwable rootCause;
            DefaultScriptTrace scriptTrace = DefaultScriptTrace.errorTrace(Duration.ofNanos(System.nanoTime() - startNanos), request, e);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Caught exception evaluating script for {}. {}{}{}", new Object[]{request.getScopeContainer(), request.getLanguage(), System.lineSeparator(), request.getScript()});
            }
            this.enhanceScriptTrace(request, scriptTrace);
            if (this.scriptErrorListener != null) {
                this.notifyScriptTraceListener(this.scriptErrorListener, scriptTrace);
            }
            if ((rootCause = ExceptionUtils.getRootCause((Throwable)e)) instanceof FlowableException) {
                throw (FlowableException)rootCause;
            }
            throw new FlowableScriptEvaluationException(scriptTrace, e);
        }
    }

    protected void notifyScriptTraceListener(ScriptTraceListener listener, ScriptTrace scriptTrace) {
        try {
            listener.onScriptTrace(scriptTrace);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while executing scriptTraceListener: {} with {}", new Object[]{listener, scriptTrace, e});
        }
    }

    protected void enhanceScriptTrace(ScriptEngineRequest request, DefaultScriptTrace scriptTrace) {
        if (this.defaultTraceEnhancer != null) {
            this.defaultTraceEnhancer.enhanceScriptTrace(scriptTrace);
        }
        if (request.getTraceEnhancer() != null) {
            request.getTraceEnhancer().enhanceScriptTrace(scriptTrace);
        }
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptTraceEnhancer getDefaultTraceEnhancer() {
        return this.defaultTraceEnhancer;
    }

    public void setDefaultTraceEnhancer(ScriptTraceEnhancer defaultTraceEnhancer) {
        this.defaultTraceEnhancer = defaultTraceEnhancer;
    }

    public ScriptTraceListener getScriptErrorListener() {
        return this.scriptErrorListener;
    }

    public void setScriptErrorListener(ScriptTraceListener scriptErrorListener) {
        this.scriptErrorListener = scriptErrorListener;
    }

    public ScriptTraceListener getScriptSuccessListener() {
        return this.scriptSuccessListener;
    }

    public void setScriptSuccessListener(ScriptTraceListener scriptSuccessListener) {
        this.scriptSuccessListener = scriptSuccessListener;
    }
}

