/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.cronofy;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.cronofy.CronofyProfile;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;

public class CronofyProfileDefinition
extends OAuthProfileDefinition {
    public static final String SUB = "sub";
    public static final String ACCOUNT_ID = "account_id";
    public static final String PROVIDER_NAME = "provider_name";
    public static final String PROFILE_ID = "profile_id";
    public static final String PROFILE_NAME = "profile_name";
    public static final String PROVIDER_SERVICE = "provider_service";

    public CronofyProfileDefinition() {
        super(x -> new CronofyProfile());
        Arrays.stream(new String[]{ACCOUNT_ID, PROVIDER_NAME, PROFILE_ID, PROFILE_NAME, PROVIDER_SERVICE}).forEach(a -> this.primary((String)a, Converters.STRING));
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return null;
    }

    @Override
    public CronofyProfile extractUserProfile(String body) {
        CronofyProfile profile = (CronofyProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, SUB)));
            this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, ACCOUNT_ID, JsonHelper.getElement(json, ACCOUNT_ID));
            JsonNode linkingProfile = (JsonNode)JsonHelper.getElement(json, "linking_profile");
            if (linkingProfile != null) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, PROVIDER_NAME, JsonHelper.getElement(linkingProfile, PROVIDER_NAME));
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, PROFILE_ID, JsonHelper.getElement(linkingProfile, PROFILE_ID));
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, PROFILE_NAME, JsonHelper.getElement(linkingProfile, PROFILE_NAME));
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, PROVIDER_SERVICE, JsonHelper.getElement(linkingProfile, PROVIDER_SERVICE));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

