/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.google2;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.google2.Google2Profile;

public class Google2ProfileDefinition
extends OAuthProfileDefinition {
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GIVEN_NAME = "given_name";
    public static final String NAME = "name";
    public static final String PICTURE = "picture";
    public static final String PROFILE = "profile";

    public Google2ProfileDefinition() {
        super(x -> new Google2Profile());
        this.primary(EMAIL_VERIFIED, Converters.BOOLEAN);
        this.primary(GIVEN_NAME, Converters.STRING);
        this.primary(NAME, Converters.STRING);
        this.primary(PICTURE, Converters.URL);
        this.primary(PROFILE, Converters.URL);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://www.googleapis.com/oauth2/v3/userinfo";
    }

    @Override
    public Google2Profile extractUserProfile(String body) {
        Google2Profile profile = (Google2Profile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, "sub")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

