/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.impl.BasicParserPool;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.support.saml.DefaultOpenSamlConfigBean;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SAML})
@AutoConfiguration
public class CasCoreSamlAutoConfiguration {
    private static final int POOL_SIZE = 1000;

    @Lazy
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean(name={"shibboleth.VelocityEngine", "velocityEngineFactoryBean", "velocityEngineFactory"})
    @ConditionalOnMissingBean(name={"velocityEngineFactoryBean"})
    public VelocityEngine velocityEngineFactoryBean() {
        Properties properties = new Properties();
        properties.put("resource.default_encoding", StandardCharsets.UTF_8.name());
        properties.put("UTF-8", StandardCharsets.UTF_8.name());
        properties.put("resource.loaders", "classpath, string, file");
        properties.put("resource.loader.file.path", FileUtils.getTempDirectory().getAbsolutePath());
        properties.put("resource.loader.file.cache", Boolean.FALSE);
        properties.put(String.format("%s.classpath.class", "resource.loader"), ClasspathResourceLoader.class.getName());
        properties.put(String.format("%s.string.class", "resource.loader"), StringResourceLoader.class.getName());
        properties.put(String.format("%s.file.class", "resource.loader"), FileResourceLoader.class.getName());
        return new VelocityEngine(properties);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean(name={"shibboleth.OpenSAMLConfig", "shibboleth.OpenSAMLConfig"})
    public OpenSamlConfigBean openSamlConfigBean(ConfigurableApplicationContext applicationContext, @Qualifier(value="shibboleth.VelocityEngine") VelocityEngine velocityEngine, @Qualifier(value="shibboleth.ParserPool") ParserPool parserPool) {
        return new DefaultOpenSamlConfigBean(parserPool, velocityEngine, applicationContext);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean(name={"shibboleth.ParserPool", "basicParserPool"}, initMethod="initialize")
    public ParserPool parserPool(CasConfigurationProperties casProperties) throws Exception {
        BasicParserPool pool = new BasicParserPool();
        pool.setMaxPoolSize(1000);
        pool.setCoalescing(true);
        pool.setIgnoreComments(true);
        pool.setXincludeAware(false);
        pool.setExpandEntityReferences(false);
        pool.setIgnoreComments(true);
        pool.setNamespaceAware(true);
        HashMap attributes = new HashMap();
        Class clazz = ClassUtils.getClass((String)casProperties.getSamlCore().getSecurityManager());
        attributes.put("http://apache.org/xml/properties/security-manager", clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        pool.setBuilderAttributes(attributes);
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        pool.setBuilderFeatures(features);
        return pool;
    }

    @Bean(name={"shibboleth.BuilderFactory"})
    @DependsOn(value={"shibboleth.OpenSAMLConfig"})
    public XMLObjectBuilderFactory builderFactory() {
        return XMLObjectProviderRegistrySupport.getBuilderFactory();
    }

    @Bean(name={"shibboleth.MarshallerFactory"})
    @DependsOn(value={"shibboleth.OpenSAMLConfig"})
    public MarshallerFactory marshallerFactory() {
        return XMLObjectProviderRegistrySupport.getMarshallerFactory();
    }

    @Bean(name={"shibboleth.UnmarshallerFactory"})
    @DependsOn(value={"shibboleth.OpenSAMLConfig"})
    public UnmarshallerFactory unmarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }
}

