/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import com.codahale.metrics.MetricRegistry;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.metrics.MetricsSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateMetricContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateMetricContext.class);
    @Nullable
    private String counterName;
    @NonnullAfterInit
    private Function<ProfileRequestContext, Boolean> metricStrategy;

    public void setCounterName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.counterName = StringSupport.trimOrNull((String)name);
    }

    public void setMetricStrategy(@Nullable Function<ProfileRequestContext, Boolean> strategy) {
        this.checkSetterPreconditions();
        this.metricStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metricStrategy == null) {
            this.metricStrategy = new NullFunction();
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricRegistry registry;
        if (this.counterName != null && (registry = MetricsSupport.getMetricRegistry()) != null) {
            registry.counter(this.counterName).inc();
        }
        MetricContext metricCtx = new MetricContext();
        profileRequestContext.addSubcontext((BaseContext)metricCtx, true);
        if (!this.metricStrategy.apply(profileRequestContext).booleanValue()) {
            this.log.warn("{} Configuration of metric mappings by supplied strategy function failed", (Object)this.getLogPrefix());
        }
    }

    private class NullFunction
    implements Function<ProfileRequestContext, Boolean> {
        private NullFunction() {
        }

        @Override
        public Boolean apply(ProfileRequestContext input) {
            input.removeSubcontext(MetricContext.class);
            return true;
        }
    }
}

