/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.AtomicDouble;

class AtlasGauge
extends AtlasMeter
implements Gauge {
    private final AtomicDouble value = new AtomicDouble(0.0);
    private final Id stat;

    AtlasGauge(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stat = AtlasMeter.addIfMissing(id, (Tag)Statistic.gauge, DsType.gauge);
    }

    @Override
    void measure(long now, MeasurementConsumer consumer) {
        double v = this.value();
        if (Double.isFinite(v)) {
            consumer.accept(this.stat, this.clock.wallTime(), v);
        }
    }

    public void set(double v) {
        this.value.set(v);
        this.updateLastModTime(this.clock.wallTime());
    }

    public double value() {
        return this.value.get();
    }
}

