/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.JsonGenerator;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JsonSerializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.SerializerProvider;
import java.io.IOException;
import java.util.function.Function;

public class MeasurementSerializer
extends JsonSerializer<Measurement> {
    private final Function<String, String> fixTagString;

    public MeasurementSerializer(Function<String, String> fixTagString) {
        this.fixTagString = fixTagString;
    }

    @Override
    public void serialize(Measurement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Id id = value.id();
        gen.writeStartObject();
        gen.writeObjectFieldStart("tags");
        gen.writeStringField("name", this.fixTagString.apply(id.name()));
        boolean explicitDsType = false;
        int n = id.size();
        for (int i = 1; i < n; ++i) {
            String k = this.fixTagString.apply(id.getKey(i));
            String v = this.fixTagString.apply(id.getValue(i));
            if ("name".equals(k)) continue;
            if ("atlas.dstype".equals(k)) {
                explicitDsType = true;
            }
            gen.writeStringField(k, v);
        }
        if (!explicitDsType) {
            gen.writeStringField("atlas.dstype", "gauge");
        }
        gen.writeEndObject();
        gen.writeNumberField("timestamp", value.timestamp());
        gen.writeNumberField("value", value.value());
        gen.writeEndObject();
    }
}

