/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.client;

import com.signalfx.shaded.apache.http.HeaderElement;
import com.signalfx.shaded.apache.http.HttpResponse;
import com.signalfx.shaded.apache.http.annotation.Contract;
import com.signalfx.shaded.apache.http.annotation.ThreadingBehavior;
import com.signalfx.shaded.apache.http.conn.ConnectionKeepAliveStrategy;
import com.signalfx.shaded.apache.http.message.BasicHeaderElementIterator;
import com.signalfx.shaded.apache.http.protocol.HttpContext;
import com.signalfx.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1L;
    }
}

