/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.monitor.ExecutableObserver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Monitoring, CasFeatureModule.FeatureCatalog.TicketRegistry})
@Configuration(value="CasCoreTicketsMonitoringConfiguration", proxyBeanMethods=false)
@Lazy(value=false)
@ConditionalOnEnabledTracing
class CasCoreTicketsMonitoringConfiguration {
    CasCoreTicketsMonitoringConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"ticketRegistryMonitoringAspect"})
    public TicketRegistryMonitoringAspect ticketRegistryMonitoringAspect(ObjectProvider<ExecutableObserver> observer) {
        return new TicketRegistryMonitoringAspect(observer);
    }

    @Aspect
    record TicketRegistryMonitoringAspect(ObjectProvider<ExecutableObserver> observerProvider) {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegistryMonitoringAspect.class);

        @Around(value="allComponentsInTicketRegistryNamespace()")
        public Object aroundTicketRegistryOperations(ProceedingJoinPoint joinPoint) throws Throwable {
            return ExecutableObserver.observe(this.observerProvider, (ProceedingJoinPoint)joinPoint);
        }

        @Pointcut(value="within(org.apereo.cas.ticket.registry.*)")
        private void allComponentsInTicketRegistryNamespace() {
        }
    }
}

