/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.BaseBean;

public class OpEvent
implements BaseBean {
    private static final long serialVersionUID = 7407774670487934097L;
    public static final String AUTHENTICATION_CATEGORY = "AUTHENTICATION";
    public static final String LOGIN_OP = "login";
    private final CategoryType type;
    private final String category;
    private final String subcategory;
    private final String op;
    private final Outcome outcome;

    @JsonCreator
    public static OpEvent fromString(String event) {
        CategoryType categoryType;
        if (StringUtils.isBlank((CharSequence)event)) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        String[] elements = event.substring(1, event.length() - 1).split("\\]:\\[");
        String category = null;
        String subCategory = null;
        Outcome outcome = null;
        String op = null;
        if (elements.length == 1) {
            categoryType = CategoryType.CUSTOM;
            outcome = Outcome.SUCCESS;
            op = event;
        } else {
            categoryType = CategoryType.valueOf(elements[0]);
            if (StringUtils.isNotEmpty((CharSequence)elements[1])) {
                category = elements[1];
            }
            if (StringUtils.isNotEmpty((CharSequence)elements[2])) {
                subCategory = elements[2];
            }
            if (elements.length > 3 && StringUtils.isNotEmpty((CharSequence)elements[3])) {
                op = elements[3];
            }
            if (elements.length > 4) {
                outcome = Outcome.valueOf(elements[4].toUpperCase());
            }
        }
        return new OpEvent(categoryType, category, subCategory, op, outcome);
    }

    public static String toString(CategoryType type, String category, String subcategory, String op, Outcome outcome) {
        StringBuilder eventBuilder = new StringBuilder();
        eventBuilder.append('[');
        if (type != null) {
            eventBuilder.append(type.name());
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)category)) {
            eventBuilder.append(category);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)subcategory)) {
            eventBuilder.append(subcategory);
        }
        eventBuilder.append("]:[");
        if (StringUtils.isNotBlank((CharSequence)op)) {
            eventBuilder.append(op);
        }
        eventBuilder.append("]:[");
        if (outcome != null) {
            eventBuilder.append((Object)outcome);
        }
        eventBuilder.append(']');
        return eventBuilder.toString();
    }

    @JsonCreator
    public OpEvent(@JsonProperty(value="type") CategoryType type, @JsonProperty(value="category") String category, @JsonProperty(value="subcategory") String subcategory, @JsonProperty(value="op") String op, @JsonProperty(value="outcome") Outcome outcome) {
        this.type = Optional.ofNullable(type).orElse(CategoryType.CUSTOM);
        this.category = category;
        this.subcategory = subcategory;
        this.op = op;
        this.outcome = Optional.ofNullable(outcome).orElse(Outcome.SUCCESS);
    }

    public CategoryType getType() {
        return this.type;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public String getOp() {
        return this.op;
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.category).append((Object)this.subcategory).append((Object)this.op).append((Object)this.outcome).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpEvent other = (OpEvent)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.category, (Object)other.category).append((Object)this.subcategory, (Object)other.subcategory).append((Object)this.op, (Object)other.op).append((Object)this.outcome, (Object)other.outcome).build();
    }

    public String toString() {
        return OpEvent.toString(this.type, this.category, this.subcategory, this.op, this.outcome);
    }

    public static enum CategoryType {
        LOGIC,
        WA,
        TASK,
        REPORT,
        PROPAGATION,
        PULL,
        PUSH,
        CUSTOM;

    }

    public static enum Outcome {
        SUCCESS,
        FAILURE;

    }
}

