/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.TestUtils$;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TestFeatureVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0005\tud\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\nyBqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004_\u0001\u0001\u0006I!\u0013\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006_\u0002!\t\u0001\u0019\u0005\u0006c\u0002!\t\u0001\u0019\u0005\u0006g\u0002!\t\u0001\u0019\u0005\u0006k\u0002!\t\u0001\u0019\u0005\u0006o\u0002!\t\u0001\u0019\u0005\u0006s\u0002!\t\u0001\u0019\u0005\u0006w\u0002!\t\u0001\u0019\u0005\u0006{\u0002!IA \u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0005\u0003\u001bBa!a\u0019\u0001\t\u0003\u0001\u0007BBA4\u0001\u0011\u0005\u0001\r\u0003\u0004\u0002l\u0001!\t\u0001\u0019\u0005\u0007\u0003_\u0002A\u0011\u00011\t\r\u0005M\u0004\u0001\"\u0001a\u0011\u0019\t9\b\u0001C\u0001A\"1\u00111\u0010\u0001\u0005\u0002\u0001Da!a \u0001\t\u0003\u0001\u0007BBAB\u0001\u0011\u0005\u0001\rC\u0004\u0002\b\u0002!I!!#\t\r\u0005e\u0006\u0001\"\u0001a\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!a5\u0001\t\u0003\t)\u000eC\u0004\u0003\u0002\u0001!\tAa\u0001\t\r\tU\u0001\u0001\"\u0001a\u0011\u0019\u0011I\u0002\u0001C\u0001A\"1!Q\u0004\u0001\u0005\u0002\u0001DaA!\t\u0001\t\u0003\u0001\u0007B\u0002B\u0013\u0001\u0011\u0005\u0001\r\u0003\u0004\u0003*\u0001!\t\u0001\u0019\u0004\u0007\u0005[\u0001\u0001Aa\f\t\u0015\tm2E!A!\u0002\u0013\t\t\u0004\u0003\u0004:G\u0011\u0005!Q\b\u0005\u0007\u0005\u000b\u0002A\u0011\u00011\t\r\t%\u0003\u0001\"\u0001a\u0011\u0019\u0011i\u0005\u0001C\u0001A\"9!\u0011\u000b\u0001\u0005\u0002\tM\u0003B\u0002B6\u0001\u0011\u0005\u0001\r\u0003\u0004\u0003p\u0001!\t\u0001\u0019\u0002\u0010'R|'/Y4f)>|G\u000eV3ti*\u0011afL\u0001\u0006i>|Gn\u001d\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003y\u0001i\u0011!L\u0001\u0019]\u0016<8+\u001a7g\u001b\u0006t\u0017mZ3e!J|\u0007/\u001a:uS\u0016\u001cH#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001B;uS2T\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u0017\u0005dGNR3biV\u0014Xm]\u000b\u0002\u0013B\u0019!jT)\u000e\u0003-S!\u0001T'\u0002\u0013%lW.\u001e;bE2,'B\u0001(6\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003!.\u0013A\u0001T5tiB\u0011!\u000bX\u0007\u0002'*\u0011A+V\u0001\u0007G>lWn\u001c8\u000b\u0005Y;\u0016AB:feZ,'O\u0003\u000211*\u0011\u0011LW\u0001\u0007CB\f7\r[3\u000b\u0003m\u000b1a\u001c:h\u0013\ti6K\u0001\u0005GK\u0006$XO]3t\u00031\tG\u000e\u001c$fCR,(/Z:!\u0003i!Xm\u001d;D_:4\u0017n\u001a+p\u0019><G)\u001b:fGR|'/[3t)\u0005\t\u0007C\u0001\u001bc\u0013\t\u0019WG\u0001\u0003V]&$\bFA\u0003f!\t1W.D\u0001h\u0015\tA\u0017.A\u0002ba&T!A[6\u0002\u000f),\b/\u001b;fe*\u0011ANW\u0001\u0006UVt\u0017\u000e^\u0005\u0003]\u001e\u0014A\u0001V3ti\u0006AC/Z:u\u0007>tg-[4U_2{w\rR5sK\u000e$xN]5fg^KG\u000f['fi\u0006dun\u001a#je\"\u0012a!Z\u0001 i\u0016\u001cH/\u00138g_\u000e{W.\\1oI>sW)\u001c9us\u0012K'/Z2u_JL\bFA\u0004f\u0003\u0005\"Xm\u001d;J]\u001a|7i\\7nC:$wJ\\'jgNLgn\u001a#je\u0016\u001cGo\u001c:zQ\tAQ-\u0001\u0011uKN$\u0018J\u001c4p\u0007>lW.\u00198e\u001f:$\u0015N]3di>\u0014\u00180Q:GS2,\u0007FA\u0005f\u0003\u001d\"Xm\u001d;J]\u001a|w+\u001b;i\u001b&\u001cX.\u0019;dQ\u0016$G*Z4bGf\\\u0015MZ6b\u0007>tg-[4)\u0005))\u0017\u0001\f;fgRLeNZ8XSRDW*[:nCR\u001c\u0007.\u001a3TK24W*\u00198bO\u0016$7*\u00194lC\u000e{gNZ5hQ\tYQ-\u0001\ruKN$hi\u001c:nCR,U\u000e\u001d;z\t&\u0014Xm\u0019;pefD#\u0001D3\u0002!I,hNR8s[\u0006$8i\\7nC:$GcB@\u0002\u0006\u0005U\u0011\u0011\t\t\u0004i\u0005\u0005\u0011bAA\u0002k\t\u0019\u0011J\u001c;\t\u000f\u0005\u001dQ\u00021\u0001\u0002\n\u000511\u000f\u001e:fC6\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0019\u0015AA5p\u0013\u0011\t\u0019\"!\u0004\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\"9\u0011qC\u0007A\u0002\u0005e\u0011a\u00033je\u0016\u001cGo\u001c:jKN\u0004b!a\u0007\u0002,\u0005Eb\u0002BA\u000f\u0003OqA!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\t\u0014A\u0002\u001fs_>$h(C\u00017\u0013\r\tI#N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti#a\f\u0003\u0007M+\u0017OC\u0002\u0002*U\u0002B!a\r\u0002<9!\u0011QGA\u001c!\r\ty\"N\u0005\u0004\u0003s)\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0005}\"AB*ue&twMC\u0002\u0002:UB\u0011\"a\u0011\u000e!\u0003\u0005\r!!\u0012\u0002\u001f%<gn\u001c:f\r>\u0014X.\u0019;uK\u0012\u00042\u0001NA$\u0013\r\tI%\u000e\u0002\b\u0005>|G.Z1o\u0003i\u0011XO\u001c$pe6\fGoQ8n[\u0006tG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tyE\u000b\u0003\u0002F\u0005E3FAA*!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uS'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0019\u0002X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002]Q,7\u000f\u001e$pe6\fGoU;dG\u0016,Gm]%g\u00032dG)\u001b:fGR|'/[3t\u0003J,\u0017I^1jY\u0006\u0014G.\u001a\u0015\u0003\u001f\u0015\f!\u0007^3ti\u001a{'/\\1u'V\u001c7-Z3eg&3\u0017\t\u001e'fCN$xJ\\3ESJ,7\r^8ss&\u001b\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0003!\u0015\fQ\u0006^3ti\u001a{'/\\1u\r\u0006LGn]%g\u00032dG)\u001b:fGR|'/[3t\u0003J,WK\\1wC&d\u0017M\u00197fQ\t\tR-A\u001euKN$hi\u001c:nCR\u001cVoY2fK\u0012\u001c\u0018JZ!u\u0019\u0016\f7\u000f^(oK\u001a{'/\\1ui\u0016$G)\u001b:fGR|'/_%t\u0003Z\f\u0017\u000e\\1cY\u0016D#AE3\u0002=Q,7\u000f\u001e$pe6\fGoV5uQ&sg/\u00197jI\u000ecWo\u001d;fe&#\u0007FA\nf\u0003i!Xm\u001d;EK\u001a\fW\u000f\u001c;NKR\fG-\u0019;b-\u0016\u00148/[8oQ\t!R-A\u000fuKN$8i\u001c8gS\u001e,(/\u001a3NKR\fG-\u0019;b-\u0016\u00148/[8oQ\t)R-\u0001\u0015uKN$8+\u001a;uS:<g)Z1ukJ,\u0017I\u001c3SK2,\u0017m]3WKJ\u001c\u0018n\u001c8GC&d7\u000f\u000b\u0002\u0017K\u0006\tB/Z:u!\u0006\u00148/\u001a$fCR,(/Z:)\u0005])\u0017!\u00049beN,g)Z1ukJ,7\u000f\u0006\u0003\u0002\f\u0006u\u0005\u0003CA\u001a\u0003\u001b\u000b\t$!%\n\t\u0005=\u0015q\b\u0002\u0004\u001b\u0006\u0004\b\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]5)\u0001\u0003mC:<\u0017\u0002BAN\u0003+\u0013Qa\u00155peRDq!a(\u0019\u0001\u0004\t\t+A\u0005oC6,7\u000f]1dKB!\u00111UA[\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016aA5oM*!\u00111VAW\u0003)\t'o\u001a9beN,GG\u001b\u0006\u0005\u0003_\u000b\t,A\u0006t_V\u00148-\u001a4pe\u001e,'BAAZ\u0003\rqW\r^\u0005\u0005\u0003o\u000b)KA\u0005OC6,7\u000f]1dK\u0006AB/Z:u\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u001ac\u0017mZ:)\u0005e)\u0017AD4f]\u0016\u0014\u0018\r^3SK\u000e|'\u000f\u001a\u000b\u0007\u0003\u0003\f9-a3\u0011\u0007I\u000b\u0019-C\u0002\u0002FN\u0013A#\u00119j\u001b\u0016\u001c8/Y4f\u0003:$g+\u001a:tS>t\u0007bBAe5\u0001\u0007\u0011\u0011G\u0001\fM\u0016\fG/\u001e:f\u001d\u0006lW\rC\u0004\u0002Nj\u0001\r!a4\u0002\u000b1,g/\u001a7\u0011\u0007Q\n\t.C\u0002\u0002\u001cV\nq\u0002^3ti\u001a+\u0017\r^;sK\u001ac\u0017m\u001a\u000b\u0004C\u0006]\u0007bBAm7\u0001\u0007\u00111\\\u0001\u0013i\u0016\u001cHOR3biV\u0014XMV3sg&|g\u000eE\u0002S\u0003;L1!a8T\u0005I!Vm\u001d;GK\u0006$XO]3WKJ\u001c\u0018n\u001c8)\u0007m\t\u0019\u000f\u0005\u0003\u0002f\u0006-XBAAt\u0015\r\tI/[\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u00055\u0018q\u001d\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bfB\u000e\u0002r\u0006u\u0018q \t\u0005\u0003g\fI0\u0004\u0002\u0002v*!\u0011q_At\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA~\u0003k\u0014!\"\u00128v[N{WO]2f\u0003\u00151\u0018\r\\;fG\t\tY.\u0001\nuKN$h+\u001a:tS>tG)\u001a4bk2$HcA1\u0003\u0006!9!q\u0001\u000fA\u0002\t%\u0011aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0011\u0007I\u0013Y!C\u0002\u0003\u000eM\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u00049\u0005\r\bf\u0002\u000f\u0002r\u0006u(1C\u0012\u0003\u0005\u0013\t\u0001\u0004^3tiZ+'o]5p]\u0012+g-Y;mi:{\u0017I]4tQ\tiR-A\u000buKN$h)Z1ukJ,G)\u001a9f]\u0012,gnY=)\u0005y)\u0017\u0001\u000b;fgRd\u0015\r^3ti\u001a+\u0017\r^;sKN<\u0016\u000e\u001e5PY\u0012lU\r^1eCR\fg+\u001a:tS>t\u0007FA\u0010f\u0003Y!Xm\u001d;GK\u0006$XO]3J]Z\fG.\u001b3GY\u0006<\u0007F\u0001\u0011f\u0003y!Xm\u001d;V]N$\u0018M\u00197f\r\u0016\fG/\u001e:f)\"\u0014xn^:FeJ|'\u000f\u000b\u0002\"K\u0006aA/Z:u\u0003\u0012$7k\u0019:b[\"\u0012!%\u001a\u0002\u0019'R|'/Y4f)>|G\u000eV3ti\u0016C8-\u001a9uS>t7cA\u0012\u00032A!!1\u0007B\u001c\u001b\t\u0011)D\u0003\u0002U/&!!\u0011\bB\u001b\u00059Y\u0015MZ6b\u000bb\u001cW\r\u001d;j_:\fq!\\3tg\u0006<W\r\u0006\u0003\u0003@\t\r\u0003c\u0001B!G5\t\u0001\u0001C\u0004\u0003<\u0015\u0002\r!!\r\u0002?Q,7\u000f^*de\u0006lw+\u001b;i\u0005\u0006$W*\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u000b\u0002'K\u0006qB/Z:u\u001d>\u001c6M]1n/&$\b.T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003O\u0015\fQ\u0003^3ti\u0012K'/V;jI\u001e+g.\u001a:bi&|g\u000e\u000b\u0002)K\u0006aC/Z:u\r>\u0014X.\u0019;uS:<WK\\:uC\ndW-T3uC\u0012\fG/\u0019,feNLwN\u001c\"m_\u000e\\W\r\u001a\u000b\u0004C\nU\u0003b\u0002B,S\u0001\u0007\u0011QI\u0001\u000fK:\f'\r\\3V]N$\u0018M\u00197fQ\rI\u00131\u001d\u0015\bS\tu#1\rB3!\u0011\t\u0019Pa\u0018\n\t\t\u0005\u0014Q\u001f\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\u00119G!\u001b\u001a\u0003\u0001I\u0012!A\u0001,i\u0016\u001cHOR8s[\u0006$h+\u00197jI\u0006$Xm]\"p]\u001aLwMR8s\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\"\u0012!&Z\u0001\u001ai\u0016\u001cHO\u00132pIN+\b\u000f]8siZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002,K\":\u0001A!\u001e\u0002~\nm\u0004c\u00014\u0003x%\u0019!\u0011P4\u0003\u000fQKW.Z8viz\t\u0001\u0006")
public class StorageToolTest {
    private final List<Features> allFeatures = Predef$.MODULE$.wrapRefArray((Object[])Features.FEATURES).toList();

    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo,/tmp/bar");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("node.id", "2");
        properties.setProperty("controller.quorum.voters", "2@localhost:9092");
        properties.setProperty("controller.listener.names", "PLAINTEXT");
        return properties;
    }

    public List<Features> allFeatures() {
        return this.allFeatures;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((java.util.Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty("metadata.log.dir", "/tmp/baz");
        KafkaConfig config = new KafkaConfig((java.util.Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(246).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedSelfManagedKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatEmptyDirectory() {
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            Assertions.assertTrue((boolean)stream.toString().startsWith(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tempDir}))));
            try {
                Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(new ByteArrayOutputStream()), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            }
            catch (TerseFailure e) {
                Assertions.assertEquals((Object)new StringBuilder(107).append("Log directory ").append(tempDir).append(" is already ").append("formatted. Use --ignore-formatted to ignore this directory and format the ").append("others.").toString(), (Object)e.getMessage());
            }
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream2), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), true));
            Assertions.assertEquals((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("All of the log directories are already formatted.%n"), (scala.collection.immutable.Seq)Nil$.MODULE$), (Object)stream2.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    private int runFormatCommand(ByteArrayOutputStream stream, scala.collection.immutable.Seq<String> directories, boolean ignoreFormatted) {
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
        BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
        return StorageTool$.MODULE$.formatCommand(new PrintStream(stream), directories, metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), ignoreFormatted);
    }

    private boolean runFormatCommand$default$3() {
        return false;
    }

    @Test
    public void testFormatSucceedsIfAllDirectoriesAreAvailable() {
        scala.collection.immutable.Seq availableDirs = (scala.collection.immutable.Seq)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$))).map((Function1 & Serializable)dir -> dir.toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, (scala.collection.immutable.Seq<String>)availableDirs, false));
        String[] actual = stream.toString().split("\\r?\\n");
        ((scala.collection.immutable.Seq)availableDirs.map((Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x$1})))).foreach((Function1 & Serializable)dir -> {
            StorageToolTest.$anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$3(actual, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneDirectoryIsAvailable() {
        File availableDir1 = TestUtils.tempDirectory(null, null);
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)availableDir1.toString(), (List)new .colon.colon((Object)unavailableDir1.toString(), (List)Nil$.MODULE$)), false));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{availableDir1}))));
        Assertions.assertFalse((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))));
    }

    @Test
    public void testFormatFailsIfAllDirectoriesAreUnavailable() {
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        File unavailableDir2 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"No available log directories to format.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)unavailableDir1.toString(), (List)new .colon.colon((Object)unavailableDir2.toString(), (List)Nil$.MODULE$)), false)).getMessage());
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))));
        Assertions.assertTrue((boolean)stream.toString().contains(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring..."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir2}))));
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneFormattedDirectoryIsAvailable() {
        File availableDir1 = TestUtils.tempDirectory(null, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)availableDir1.toString(), (List)Nil$.MODULE$), false));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        File unavailableDir1 = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream2, (scala.collection.immutable.Seq<String>)new .colon.colon((Object)availableDir1.toString(), (List)new .colon.colon((Object)unavailableDir1.toString(), (List)Nil$.MODULE$)), true));
    }

    @Test
    public void testFormatWithInvalidClusterId() {
        KafkaConfig config = new KafkaConfig((java.util.Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)"Cluster ID string invalid does not appear to be a valid UUID: Input string `invalid` decoded as 5 bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.buildMetadataProperties("invalid", config)).getMessage());
    }

    @Test
    public void testDefaultMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"});
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$);
        Assertions.assertEquals((short)MetadataVersion.LATEST_PRODUCTION.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be the latest production version");
    }

    @Test
    public void testConfiguredMetadataVersion() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"});
        MetadataVersion mv = StorageTool$.MODULE$.getMetadataVersion(namespace, Predef$.MODULE$.Map().empty(), (Option)new Some((Object)MetadataVersion.IBP_3_3_IV2.toString()));
        Assertions.assertEquals((short)MetadataVersion.IBP_3_3_IV2.featureLevel(), (short)mv.featureLevel(), (String)"Expected the default metadata.version to be 3.3-IV2");
    }

    @Test
    public void testSettingFeatureAndReleaseVersionFails() {
        Namespace namespace = StorageTool$.MODULE$.parseArguments(new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.0-IV1", "--feature", "metadata.version=4"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageTool$.MODULE$.getMetadataVersion(namespace, this.parseFeatures(namespace), (Option)None$.MODULE$));
    }

    @Test
    public void testParseFeatures() {
        Assertions.assertThrows(RuntimeException.class, () -> this.parseAddFeatures$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--feature", "blah"})));
        Assertions.assertThrows(RuntimeException.class, () -> this.parseAddFeatures$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--feature", "blah=blah"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.parseAddFeatures$1((scala.collection.immutable.Seq)Nil$.MODULE$));
        int testFeatureLevel = 1;
        String testArgument = new StringBuilder(21).append("test.feature.version=").append(Integer.toString(testFeatureLevel)).toString();
        scala.collection.immutable.Map expectedMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.feature.version"), (Object)BoxesRunTime.boxToShort((short)((short)testFeatureLevel)))}));
        Assertions.assertEquals((Object)expectedMap, (Object)this.parseAddFeatures$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--feature", testArgument})));
        int metadataFeatureLevel = 5;
        String metadataArgument = new StringBuilder(17).append("metadata.version=").append(Integer.toString(metadataFeatureLevel)).toString();
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)expectedMap.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)BoxesRunTime.boxToShort((short)((short)metadataFeatureLevel)))})))), (Object)this.parseAddFeatures$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--feature", testArgument, "--feature", metadataArgument})));
    }

    private scala.collection.immutable.Map<String, Short> parseFeatures(Namespace namespace) {
        java.util.List specifiedFeatures = namespace.getList("feature");
        return StorageTool$.MODULE$.featureNamesAndLevels(CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)Option$.MODULE$.apply((Object)specifiedFeatures).getOrElse((Function0 & Serializable)() -> Collections.emptyList())).asScala().toList());
    }

    @Test
    public void testMetadataVersionFlags() {
        MetadataVersion mv = StorageToolTest.parseMetadataVersion$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0"}));
        Assertions.assertEquals((Object)"3.0", (Object)mv.shortVersion());
        mv = StorageToolTest.parseMetadataVersion$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.0-IV1"}));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)mv);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageToolTest.parseMetadataVersion$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "0.0"})));
    }

    private ApiMessageAndVersion generateRecord(String featureName, short level) {
        return new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(featureName).setFeatureLevel(level), (short)0);
    }

    @ParameterizedTest
    @EnumSource(value=TestFeatureVersion.class)
    public void testFeatureFlag(TestFeatureVersion testFeatureVersion) {
        short featureLevel = testFeatureVersion.featureLevel();
        if (featureLevel <= Features.TEST_VERSION.defaultValue(MetadataVersion.LATEST_PRODUCTION)) {
            ArrayBuffer records = new ArrayBuffer();
            StorageTool$.MODULE$.generateFeatureRecords(records, MetadataVersion.LATEST_PRODUCTION, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.feature.version"), (Object)Predef$.MODULE$.short2Short(featureLevel))})), this.allFeatures(), false, false);
            if (featureLevel > 0) {
                Assertions.assertEquals((Object)new .colon.colon((Object)this.generateRecord("test.feature.version", featureLevel), (List)Nil$.MODULE$), (Object)records);
                return;
            }
            return;
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testVersionDefault(MetadataVersion metadataVersion) {
        ArrayBuffer records = new ArrayBuffer();
        StorageTool$.MODULE$.generateFeatureRecords(records, metadataVersion, Predef$.MODULE$.Map().empty(), this.allFeatures(), true, true);
        short featureLevel = Features.TEST_VERSION.defaultValue(metadataVersion);
        if (featureLevel > 0) {
            Assertions.assertEquals((Object)new .colon.colon((Object)this.generateRecord("test.feature.version", featureLevel), (List)Nil$.MODULE$), (Object)records);
            return;
        }
    }

    @Test
    public void testVersionDefaultNoArgs() {
        ArrayBuffer records = new ArrayBuffer();
        StorageTool$.MODULE$.generateFeatureRecords(records, MetadataVersion.LATEST_PRODUCTION, Predef$.MODULE$.Map().empty(), this.allFeatures(), false, false);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.generateRecord("test.feature.version", Features.TEST_VERSION.defaultValue(MetadataVersion.LATEST_PRODUCTION)), (List)Nil$.MODULE$), (Object)records);
    }

    @Test
    public void testFeatureDependency() {
        short featureLevel = (short)1;
        Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.generateFeatureRecords(new ArrayBuffer(), MetadataVersion.IBP_2_8_IV1, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.feature.version"), (Object)Predef$.MODULE$.short2Short(featureLevel))})), this.allFeatures(), false, false));
    }

    @Test
    public void testLatestFeaturesWithOldMetadataVersion() {
        ArrayBuffer records = new ArrayBuffer();
        StorageTool$.MODULE$.generateFeatureRecords(records, MetadataVersion.IBP_3_3_IV0, Predef$.MODULE$.Map().empty(), this.allFeatures(), false, false);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.generateRecord("test.feature.version", Features.TEST_VERSION.defaultValue(MetadataVersion.LATEST_PRODUCTION)), (List)Nil$.MODULE$), (Object)records);
    }

    @Test
    public void testFeatureInvalidFlag() {
        short featureLevel = (short)99;
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageTool$.MODULE$.generateFeatureRecords(new ArrayBuffer(), MetadataVersion.LATEST_PRODUCTION, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.feature.version"), (Object)Predef$.MODULE$.short2Short(featureLevel))})), this.allFeatures(), false, false));
    }

    @Test
    public void testUnstableFeatureThrowsError() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StorageTool$.MODULE$.generateFeatureRecords(new ArrayBuffer(), MetadataVersion.LATEST_PRODUCTION, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test.feature.version"), (Object)Predef$.MODULE$.short2Short(Features.TEST_VERSION.latestTesting()))})), this.allFeatures(), false, false));
    }

    @Test
    public void testAddScram() {
        Option scramRecords = StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)Nil$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)scramRecords);
        scramRecords = StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]", "-S", "SCRAM-SHA-256=[name=george,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"}));
        Assertions.assertEquals((int)2, (int)((SeqOps)scramRecords.get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'name' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must only supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply one of 'password' or 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\",iterations=8192]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"You must supply 'salt' with 'saltedpassword' to add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice,iterations=4096]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16385]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be <= 16384 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=16384]"})).get()).size());
        try {
            Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4095]"})));
        }
        catch (TerseFailure e) {
            Assertions.assertEquals((Object)"The 'iterations' value must be >= 4096 for add-scram", (Object)e.getMessage());
        }
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=4096]"})).get()).size());
        Assertions.assertEquals((int)1, (int)((SeqOps)StorageToolTest.parseAddScram$1((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-S", "SCRAM-SHA-256=[name=alice,password=alice]"})).get()).size());
    }

    @Test
    public void testScramWithBadMetadataVersion() {
        ObjectRef exitString = ObjectRef.create((Object)"");
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitStatus, message) -> this.exitProcedure$1(BoxesRunTime.unboxToInt((Object)exitStatus), message, exitString);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var7_2 = null;
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4", "-S", "SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",password=alice,iterations=8192]"};
        try {
            try {
                Integer n = BoxesRunTime.boxToInteger((int)1);
                StorageTool$.MODULE$.main(args);
                Assertions.assertEquals((Object)n, (Object)BoxedUnit.UNIT);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)new StringBuilder(54).append("SCRAM is only supported in metadata.version ").append(MetadataVersion.IBP_3_5_IV2).append(" or later.").toString(), (Object)((String)exitString.elem));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testNoScramWithMetadataVersion() {
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, message) -> this.exitProcedure$2(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var8_3 = null;
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        properties.setProperty("log.dirs", TestUtils.tempDirectory(null, null).toString());
        properties.store(propsStream, "config.props");
        propsStream.close();
        String[] args = new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.4"};
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {
                Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
                Assertions.assertEquals((int)0, (int)exitStatus.elem);
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testDirUuidGeneration() {
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            MetaProperties metaProperties = new MetaProperties.Builder().setClusterId("XcZZOzUqS4yHOjhMQB6JLQ").setNodeId(2).build();
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(MetadataVersion.latestTesting(), (Option)None$.MODULE$, "test format command");
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM), (scala.collection.immutable.Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$), metaProperties, bootstrapMetadata, MetadataVersion.latestTesting(), false));
            File metaPropertiesFile = Paths.get(tempDir.toURI()).resolve("meta.properties").toFile();
            Assertions.assertTrue((boolean)metaPropertiesFile.exists());
            MetaProperties metaProps = new MetaProperties.Builder(PropertiesUtils.readPropertiesFile((String)metaPropertiesFile.getAbsolutePath())).build();
            Assertions.assertTrue((boolean)metaProps.directoryId().isPresent());
            Assertions.assertFalse((boolean)DirectoryId.reserved((Uuid)((Uuid)metaProps.directoryId().get())));
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormattingUnstableMetadataVersionBlocked(boolean enableUnstable) {
        ObjectRef exitString = ObjectRef.create((Object)"");
        IntRef exitStatus = IntRef.create((int)1);
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, message) -> this.exitProcedure$3(BoxesRunTime.unboxToInt((Object)status), message, exitStatus, exitString);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var10_4 = null;
        Properties properties = this.newSelfManagedProperties();
        File propsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        try (OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);){
            properties.setProperty("log.dirs", TestUtils.tempDirectory(null, null).toString());
            properties.setProperty("unstable.feature.versions.enable", Boolean.toString(enableUnstable));
            properties.store(propsStream, "config.props");
        }
        String[] args = new String[]{"format", "-c", String.valueOf(propsFile.toPath()), "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", MetadataVersion.latestTesting().toString()};
        try {
            try {
                StorageTool$.MODULE$.main(args);
            }
            catch (StorageToolTestException storageToolTestException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        if (enableUnstable) {
            Assertions.assertEquals((Object)"", (Object)((String)exitString.elem));
            Assertions.assertEquals((int)0, (int)exitStatus.elem);
            return;
        }
        Assertions.assertEquals((Object)new StringBuilder(58).append("The metadata.version ").append(MetadataVersion.latestTesting().toString()).append(" is not ready for ").append("production use yet.").toString(), (Object)((String)exitString.elem));
        Assertions.assertEquals((int)1, (int)exitStatus.elem);
    }

    @Test
    public void testFormatValidatesConfigForMetadataVersion() {
        KafkaConfig config = (KafkaConfig)Mockito.spy((Object)new KafkaConfig((java.util.Map)TestUtils$.MODULE$.createBrokerConfig(10, null, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)));
        String[] args = new String[]{"format", "-c", "dummy.properties", "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", MetadataVersion.LATEST_PRODUCTION.toString()};
        int exitCode = StorageTool$.MODULE$.runFormatCommand(StorageTool$.MODULE$.parseArguments(args), config);
        ((KafkaConfig)Mockito.verify((Object)config, (VerificationMode)Mockito.times((int)1))).validateWithMetadataVersion(MetadataVersion.LATEST_PRODUCTION);
        Assertions.assertEquals((int)0, (int)exitCode);
    }

    @Test
    public void testJbodSupportValidation() {
        Assertions.assertEquals((int)0, (Integer)StorageToolTest.formatWith$1(1, MetadataVersion.IBP_3_6_IV2));
        Assertions.assertEquals((Object)"Invalid configuration for metadata version: requirement failed: Multiple log directories (aka JBOD) are not supported in the current MetadataVersion 3.6-IV2. Need 3.7-IV2 or higher", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageToolTest.formatWith$1(2, MetadataVersion.IBP_3_6_IV2)).getMessage());
        Assertions.assertEquals((int)0, (Integer)StorageToolTest.formatWith$1(1, MetadataVersion.IBP_3_7_IV2));
        Assertions.assertEquals((int)0, (Integer)StorageToolTest.formatWith$1(2, MetadataVersion.IBP_3_7_IV2));
    }

    public static final /* synthetic */ void $anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$3(String[] actual$1, String dir) {
        Assertions.assertEquals((int)1, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])actual$1), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith(dir))));
    }

    private final scala.collection.immutable.Map parseAddFeatures$1(scala.collection.immutable.Seq strings) {
        Seq args = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (Seq)args.$plus$plus((IterableOnce)strings);
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return this.parseFeatures(namespace);
    }

    private static final MetadataVersion parseMetadataVersion$1(scala.collection.immutable.Seq strings) {
        Seq args = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (Seq)args.$plus$plus((IterableOnce)strings);
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getMetadataVersion(namespace, Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$);
    }

    private static final Option parseAddScram$1(scala.collection.immutable.Seq strings) {
        Seq args = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"format", "-c", "config.props", "-t", "XcZZOzUqS4yHOjhMQB6JLQ"}));
        args = (Seq)args.$plus$plus((IterableOnce)strings);
        Namespace namespace = StorageTool$.MODULE$.parseArguments((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)));
        return StorageTool$.MODULE$.getUserScramCredentialRecords(namespace);
    }

    private final Nothing$ exitProcedure$1(int exitStatus, Option message, ObjectRef exitString$1) {
        exitString$1.elem = (String)message.getOrElse((Function0 & Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$1.elem);
    }

    private final Nothing$ exitProcedure$2(int status, Option message, IntRef exitStatus$1, ObjectRef exitString$2) {
        exitStatus$1.elem = status;
        exitString$2.elem = (String)message.getOrElse((Function0 & Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$2.elem);
    }

    private final Nothing$ exitProcedure$3(int status, Option message, IntRef exitStatus$2, ObjectRef exitString$3) {
        exitStatus$2.elem = status;
        exitString$3.elem = (String)message.getOrElse((Function0 & Serializable)() -> "");
        throw new StorageToolTestException((String)exitString$3.elem);
    }

    private static final Integer formatWith$1(int logDirCount, MetadataVersion metadataVersion) {
        boolean x$4 = true;
        boolean x$5 = true;
        TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
        Object var22_4 = null;
        int x$6 = createBrokerConfig$default$5_this.RandomPort();
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        boolean x$10 = true;
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$12 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$14 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$15 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var25_17 = null;
        int x$16 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$17 = None$.MODULE$;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(10, null, x$4, x$5, x$6, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<String>)x$17, logDirCount, x$18, x$19, x$20, x$21);
        properties.remove("inter.broker.protocol.version");
        String configFile = ((Object)TestUtils$.MODULE$.tempPropertiesFile((Map<String, String>)CollectionConverters$.MODULE$.PropertiesHasAsScala(properties).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toPath()).toString();
        return Predef$.MODULE$.int2Integer(StorageTool$.MODULE$.execute(new String[]{"format", "-c", configFile, "-t", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", metadataVersion.toString()}));
    }

    public class StorageToolTestException
    extends KafkaException {
        public /* synthetic */ StorageToolTest kafka$tools$StorageToolTest$StorageToolTestException$$$outer() {
            return StorageToolTest.this;
        }

        public StorageToolTestException(String message) {
            if (StorageToolTest.this == null) {
                throw null;
            }
            super(message);
        }
    }
}

