/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cookie.CookieProperties;
import org.apereo.cas.configuration.model.support.cookie.PinnableCookieProperties;
import org.apereo.cas.configuration.model.support.cookie.TicketGrantingCookieProperties;
import org.apereo.cas.configuration.model.support.cookie.WarningCookieProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.cipher.TicketGrantingCookieCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.cookie.CookieGenerationContext;
import org.apereo.cas.web.cookie.CookieValueManager;
import org.apereo.cas.web.support.CookieUtils;
import org.apereo.cas.web.support.gen.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.mgmr.DefaultCasCookieValueManager;
import org.apereo.cas.web.support.mgmr.DefaultCookieSameSitePolicy;
import org.apereo.cas.web.support.mgmr.NoOpCookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Core})
@AutoConfiguration
public class CasCoreCookieAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreCookieAutoConfiguration.class);

    @Configuration(value="CasCookieGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCookieGeneratorConfiguration {
        CasCookieGeneratorConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"warnCookieGenerator"})
        public CasCookieBuilder warnCookieGenerator(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
            WarningCookieProperties props = casProperties.getWarningCookie();
            return new CookieRetrievingCookieGenerator(CookieUtils.buildCookieGenerationContext((CookieProperties)props), (CookieValueManager)new NoOpCookieValueManager(tenantExtractor));
        }

        @ConditionalOnMissingBean(name={"ticketGrantingTicketCookieGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasCookieBuilder ticketGrantingTicketCookieGenerator(CasConfigurationProperties casProperties, @Qualifier(value="cookieValueManager") CookieValueManager cookieValueManager) {
            CookieGenerationContext context = CookieUtils.buildCookieGenerationContext((TicketGrantingCookieProperties)casProperties.getTgc());
            return new CookieRetrievingCookieGenerator(context, cookieValueManager);
        }
    }

    @Configuration(value="CasCookieCoreConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCookieCoreConfiguration {
        CasCookieCoreConfiguration() {
        }

        @ConditionalOnMissingBean(name={"cookieValueManager"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CookieValueManager cookieValueManager(@Qualifier(value="geoLocationService") ObjectProvider<GeoLocationService> geoLocationService, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties, @Qualifier(value="cookieCipherExecutor") CipherExecutor cookieCipherExecutor) {
            if (casProperties.getTgc().getCrypto().isEnabled()) {
                return new DefaultCasCookieValueManager(cookieCipherExecutor, tenantExtractor, geoLocationService, DefaultCookieSameSitePolicy.INSTANCE, (PinnableCookieProperties)casProperties.getTgc());
            }
            return new NoOpCookieValueManager(tenantExtractor);
        }

        @ConditionalOnMissingBean(name={"cookieCipherExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CipherExecutor cookieCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getTgc().getCrypto();
            boolean enabled = crypto.isEnabled();
            if (!enabled && StringUtils.isNotBlank((CharSequence)crypto.getEncryption().getKey()) && StringUtils.isNotBlank((CharSequence)crypto.getSigning().getKey())) {
                LOGGER.warn("Token encryption/signing is not enabled explicitly in the configuration for cookie [{}], yet signing/encryption keys are defined for operations. CAS will proceed to enable the cookie encryption/signing functionality.", (Object)casProperties.getTgc().getName());
                enabled = true;
            }
            if (enabled) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, TicketGrantingCookieCipherExecutor.class);
            }
            LOGGER.warn("Ticket-granting cookie encryption/signing is turned off. This MAY NOT be safe in a production environment. Consider using other choices to handle encryption, signing and verification of ticket-granting cookies.");
            return CipherExecutor.noOp();
        }
    }
}

