/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.async.AsyncTaskInvoker;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.http.common.api.HttpHeaders;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.AsyncExecutableHttpRequest;
import org.flowable.http.common.api.client.ExecutableHttpRequest;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.impl.ExpressionUtils;

public abstract class BaseHttpActivityDelegate {
    public static final String HTTP_TASK_REQUEST_METHOD_REQUIRED = "requestMethod is required";
    public static final String HTTP_TASK_REQUEST_METHOD_INVALID = "requestMethod is invalid";
    public static final String HTTP_TASK_REQUEST_URL_REQUIRED = "requestUrl is required";
    public static final String HTTP_TASK_REQUEST_HEADERS_INVALID = "requestHeaders are invalid";
    public static final String HTTP_TASK_REQUEST_SECURE_HEADERS_INVALID = "requestSecureHeaders are invalid";
    public static final String HTTP_TASK_REQUEST_FIELD_INVALID = "request fields are invalid";
    protected Expression requestMethod;
    protected Expression requestUrl;
    protected Expression requestHeaders;
    protected Expression requestSecureHeaders;
    protected Expression requestBody;
    protected Expression requestBodyEncoding;
    protected Expression requestTimeout;
    protected Expression disallowRedirects;
    protected Expression failStatusCodes;
    protected Expression handleStatusCodes;
    protected Expression ignoreException;
    protected Expression saveRequestVariables;
    protected Expression saveResponseParameters;
    protected Expression responseVariableName;
    protected Expression saveResponseParametersTransient;
    protected Expression saveResponseVariableAsJson;
    protected Expression resultVariablePrefix;
    protected FlowableHttpClient httpClient;

    public BaseHttpActivityDelegate() {
        this(null);
    }

    public BaseHttpActivityDelegate(FlowableHttpClient httpClient) {
        this.httpClient = httpClient == null ? this.createHttpClient() : httpClient;
    }

    protected abstract FlowableHttpClient createHttpClient();

    protected RequestData createRequest(VariableContainer variableContainer, String fallbackPrefix) {
        HttpRequest request = new HttpRequest();
        RequestData requestData = new RequestData();
        requestData.setHttpRequest(request);
        request.setMethod(ExpressionUtils.getStringFromField(this.requestMethod, variableContainer));
        request.setUrl(ExpressionUtils.getStringFromField(this.requestUrl, variableContainer));
        request.setHttpHeaders(this.getRequestHeaders(variableContainer));
        request.setSecureHttpHeaders(this.getRequestSecureHeaders(variableContainer));
        request.setBody(ExpressionUtils.getStringFromField(this.requestBody, variableContainer));
        request.setBodyEncoding(ExpressionUtils.getStringFromField(this.requestBodyEncoding, variableContainer));
        request.setTimeout(ExpressionUtils.getIntFromField(this.requestTimeout, variableContainer));
        request.setNoRedirects(ExpressionUtils.getBooleanFromField(this.disallowRedirects, variableContainer));
        requestData.setIgnoreErrors(ExpressionUtils.getBooleanFromField(this.ignoreException, variableContainer));
        requestData.setSaveRequest(ExpressionUtils.getBooleanFromField(this.saveRequestVariables, variableContainer));
        requestData.setSaveResponse(ExpressionUtils.getBooleanFromField(this.saveResponseParameters, variableContainer));
        requestData.setSaveResponseTransient(ExpressionUtils.getBooleanFromField(this.saveResponseParametersTransient, variableContainer));
        requestData.setSaveResponseAsJson(ExpressionUtils.getBooleanFromField(this.saveResponseVariableAsJson, variableContainer));
        requestData.setPrefix(ExpressionUtils.getStringFromField(this.resultVariablePrefix, variableContainer));
        String failCodes = ExpressionUtils.getStringFromField(this.failStatusCodes, variableContainer);
        String handleCodes = ExpressionUtils.getStringFromField(this.handleStatusCodes, variableContainer);
        if (failCodes != null) {
            requestData.setFailCodes(ExpressionUtils.getStringSetFromField(failCodes));
        }
        if (handleCodes != null) {
            requestData.setHandleCodes(ExpressionUtils.getStringSetFromField(handleCodes));
        }
        if (requestData.getPrefix() == null) {
            requestData.setPrefix(fallbackPrefix);
        }
        if (requestData.isSaveRequest()) {
            String prefix = requestData.getPrefix();
            variableContainer.setVariable(prefix + "RequestMethod", (Object)request.getMethod());
            variableContainer.setVariable(prefix + "RequestUrl", (Object)request.getUrl());
            variableContainer.setVariable(prefix + "RequestHeaders", (Object)request.getHttpHeadersAsString());
            variableContainer.setVariable(prefix + "RequestSecureHeaders", (Object)request.getSecureHttpHeadersAsString());
            variableContainer.setVariable(prefix + "RequestBody", (Object)request.getBody());
            variableContainer.setVariable(prefix + "RequestBodyEncoding", (Object)request.getBodyEncoding());
            variableContainer.setVariable(prefix + "RequestTimeout", (Object)request.getTimeout());
            variableContainer.setVariable(prefix + "DisallowRedirects", (Object)request.isNoRedirects());
            variableContainer.setVariable(prefix + "FailStatusCodes", (Object)failCodes);
            variableContainer.setVariable(prefix + "HandleStatusCodes", (Object)handleCodes);
            variableContainer.setVariable(prefix + "IgnoreException", (Object)requestData.isIgnoreErrors());
            variableContainer.setVariable(prefix + "SaveRequestVariables", (Object)requestData.isSaveRequest());
            variableContainer.setVariable(prefix + "SaveResponseParameters", (Object)requestData.isSaveResponse());
        }
        return requestData;
    }

    protected void saveResponseFields(VariableContainer variableContainer, RequestData request, HttpResponse response, ObjectMapper objectMapper) throws IOException {
        if (response != null) {
            if (request.isSaveResponse()) {
                if (request.isSaveResponseTransient()) {
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseProtocol", (Object)response.getProtocol());
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseStatusCode", (Object)response.getStatusCode());
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseReason", (Object)response.getReason());
                    variableContainer.setTransientVariable(request.getPrefix() + "ResponseHeaders", (Object)response.getHttpHeadersAsString());
                } else {
                    variableContainer.setVariable(request.getPrefix() + "ResponseProtocol", (Object)response.getProtocol());
                    variableContainer.setVariable(request.getPrefix() + "ResponseStatusCode", (Object)response.getStatusCode());
                    variableContainer.setVariable(request.getPrefix() + "ResponseReason", (Object)response.getReason());
                    variableContainer.setVariable(request.getPrefix() + "ResponseHeaders", (Object)response.getHttpHeadersAsString());
                }
            }
            if (!response.isBodyResponseHandled()) {
                String varValue;
                String responseVariableName = ExpressionUtils.getStringFromField(this.responseVariableName, variableContainer);
                String varName = StringUtils.isNotEmpty((CharSequence)responseVariableName) ? responseVariableName : request.getPrefix() + "ResponseBody";
                String string = varValue = request.isSaveResponseAsJson() && response.getBody() != null ? objectMapper.readTree(response.getBody()) : response.getBody();
                if (varValue instanceof MissingNode) {
                    varValue = null;
                }
                if (request.isSaveResponseTransient()) {
                    variableContainer.setTransientVariable(varName, (Object)varValue);
                } else {
                    variableContainer.setVariable(varName, (Object)varValue);
                }
            }
            if (request.isNoRedirects() && response.getStatusCode() >= 300 || response.getStatusCode() >= 400) {
                String code = Integer.toString(response.getStatusCode());
                Set<String> handleCodes = request.getHandleCodes();
                if (handleCodes != null && !handleCodes.isEmpty() && (handleCodes.contains(code) || code.startsWith("5") && handleCodes.contains("5XX") || code.startsWith("4") && handleCodes.contains("4XX") || code.startsWith("3") && handleCodes.contains("3XX"))) {
                    this.propagateError(variableContainer, code);
                    return;
                }
                Set<String> failCodes = request.getFailCodes();
                if (failCodes != null && !failCodes.isEmpty() && (failCodes.contains(code) || code.startsWith("5") && failCodes.contains("5XX") || code.startsWith("4") && failCodes.contains("4XX") || code.startsWith("3") && failCodes.contains("3XX"))) {
                    throw new FlowableException("HTTP" + code);
                }
            }
        }
    }

    protected CompletableFuture<ExecutionData> prepareAndExecuteRequest(RequestData request, boolean parallelInSameTransaction, AsyncTaskInvoker taskInvoker) {
        ExecutableHttpRequest httpRequest = this.httpClient.prepareRequest(request.getHttpRequest());
        if (!parallelInSameTransaction) {
            CompletableFuture<ExecutionData> future = new CompletableFuture<ExecutionData>();
            try {
                HttpResponse response2 = httpRequest.call();
                future.complete(new ExecutionData(request, response2));
            }
            catch (Exception ex) {
                future.complete(new ExecutionData(request, null, ex));
            }
            return future;
        }
        if (httpRequest instanceof AsyncExecutableHttpRequest) {
            return ((AsyncExecutableHttpRequest)httpRequest).callAsync().handle((response, throwable) -> new ExecutionData(request, (HttpResponse)response, (Throwable)throwable));
        }
        return taskInvoker.submit(() -> {
            try {
                return new ExecutionData(request, httpRequest.call());
            }
            catch (Exception ex) {
                return new ExecutionData(request, null, ex);
            }
        });
    }

    protected void validateRequest(HttpRequest request) throws FlowableException {
        if (request.getMethod() == null) {
            throw new FlowableException(HTTP_TASK_REQUEST_METHOD_REQUIRED);
        }
        switch (request.getMethod()) {
            case "GET": 
            case "POST": 
            case "PUT": 
            case "PATCH": 
            case "DELETE": {
                break;
            }
            default: {
                throw new FlowableException(HTTP_TASK_REQUEST_METHOD_INVALID);
            }
        }
        if (request.getUrl() == null) {
            throw new FlowableException(HTTP_TASK_REQUEST_URL_REQUIRED);
        }
    }

    protected HttpHeaders getRequestHeaders(VariableContainer variableContainer) {
        return this.parseRequestHeaders(variableContainer, this.requestHeaders, HTTP_TASK_REQUEST_HEADERS_INVALID);
    }

    protected HttpHeaders getRequestSecureHeaders(VariableContainer variableContainer) {
        return this.parseRequestHeaders(variableContainer, this.requestSecureHeaders, HTTP_TASK_REQUEST_SECURE_HEADERS_INVALID);
    }

    protected HttpHeaders parseRequestHeaders(VariableContainer variableContainer, Expression headers, String errorPrefix) {
        try {
            String headersString = ExpressionUtils.getStringFromField(headers, variableContainer);
            return HttpHeaders.parseFromString(headersString);
        }
        catch (FlowableIllegalArgumentException ex) {
            throw new FlowableException(errorPrefix + " for " + String.valueOf(variableContainer), (Throwable)ex);
        }
    }

    protected abstract void propagateError(VariableContainer var1, String var2);

    public static class RequestData {
        protected HttpRequest httpRequest;
        protected Set<String> failCodes;
        protected Set<String> handleCodes;
        protected boolean ignoreErrors;
        protected boolean saveRequest;
        protected boolean saveResponse;
        protected boolean saveResponseTransient;
        protected boolean saveResponseAsJson;
        protected String prefix;

        public HttpRequest getHttpRequest() {
            return this.httpRequest;
        }

        public void setHttpRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
        }

        public Set<String> getFailCodes() {
            return this.failCodes;
        }

        public void setFailCodes(Set<String> failCodes) {
            this.failCodes = failCodes;
        }

        public Set<String> getHandleCodes() {
            return this.handleCodes;
        }

        public void setHandleCodes(Set<String> handleCodes) {
            this.handleCodes = handleCodes;
        }

        public boolean isIgnoreErrors() {
            return this.ignoreErrors;
        }

        public void setIgnoreErrors(boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
        }

        public boolean isSaveRequest() {
            return this.saveRequest;
        }

        public void setSaveRequest(boolean saveRequest) {
            this.saveRequest = saveRequest;
        }

        public boolean isSaveResponse() {
            return this.saveResponse;
        }

        public void setSaveResponse(boolean saveResponse) {
            this.saveResponse = saveResponse;
        }

        public boolean isSaveResponseTransient() {
            return this.saveResponseTransient;
        }

        public void setSaveResponseTransient(boolean saveResponseTransient) {
            this.saveResponseTransient = saveResponseTransient;
        }

        public boolean isSaveResponseAsJson() {
            return this.saveResponseAsJson;
        }

        public void setSaveResponseAsJson(boolean saveResponseAsJson) {
            this.saveResponseAsJson = saveResponseAsJson;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public boolean isNoRedirects() {
            return this.httpRequest.isNoRedirects();
        }
    }

    public static class ExecutionData {
        protected RequestData request;
        protected HttpResponse response;
        protected Throwable exception;

        public ExecutionData(RequestData request, HttpResponse response) {
            this(request, response, null);
        }

        public ExecutionData(RequestData request, HttpResponse response, Throwable exception) {
            this.request = request;
            this.response = response;
            this.exception = exception;
        }

        public RequestData getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

