/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GroupMemberProvisionTaskJobDelegate
extends AbstractSchedTaskJobDelegate<SchedTask> {
    public static final String ACTION_JOBDETAIL_KEY = "action";
    public static final String GROUP_KEY_JOBDETAIL_KEY = "groupKey";
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private UserProvisioningManager userProvisioningManager;
    @Autowired
    private AnyObjectProvisioningManager anyObjectProvisioningManager;
    private String groupKey;
    private ProvisionAction action;

    @Override
    @Transactional
    public void execute(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        this.groupKey = (String)context.getData().get(GROUP_KEY_JOBDETAIL_KEY);
        this.action = (ProvisionAction)context.getData().get(ACTION_JOBDETAIL_KEY);
        super.execute(taskType, taskKey, context);
    }

    @Override
    protected String doExecute(JobExecutionContext context) {
        Group group = (Group)this.groupDAO.authFind(this.groupKey);
        StringBuilder result = new StringBuilder("Group ").append(group.getName()).append(" members ");
        if (this.action == ProvisionAction.DEPROVISION) {
            result.append("de");
        }
        result.append("provision\n\n");
        this.setStatus(result.toString());
        MembershipCond membershipCond = new MembershipCond();
        membershipCond.setGroup(this.groupKey);
        List users = this.searchDAO.search(SearchCond.of((AbstractSearchCond)membershipCond), AnyTypeKind.USER);
        Collection gResources = this.groupDAO.findAllResourceKeys(this.groupKey);
        this.setStatus("About to " + (this.action == ProvisionAction.DEPROVISION ? "de" : "") + "provision " + users.size() + " users from " + String.valueOf(gResources));
        for (User user : users) {
            List statuses = this.action == ProvisionAction.DEPROVISION ? this.userProvisioningManager.deprovision(user.getKey(), gResources, false, this.executor) : this.userProvisioningManager.provision(user.getKey(), true, null, gResources, false, this.executor);
            for (PropagationStatus propagationStatus : statuses) {
                result.append("User ").append(user.getKey()).append('\t').append("Resource ").append(propagationStatus.getResource()).append('\t').append(propagationStatus.getStatus());
                if (StringUtils.isNotBlank((CharSequence)propagationStatus.getFailureReason())) {
                    result.append('\n').append(propagationStatus.getFailureReason()).append('\n');
                }
                result.append('\n');
            }
            result.append('\n');
        }
        membershipCond = new MembershipCond();
        membershipCond.setGroup(this.groupKey);
        List anyObjects = this.searchDAO.search(SearchCond.of((AbstractSearchCond)membershipCond), AnyTypeKind.ANY_OBJECT);
        this.setStatus("About to " + (this.action == ProvisionAction.DEPROVISION ? "de" : "") + "provision " + anyObjects.size() + " any objects from " + String.valueOf(gResources));
        for (AnyObject anyObject : anyObjects) {
            List statuses = this.action == ProvisionAction.DEPROVISION ? this.anyObjectProvisioningManager.deprovision(anyObject.getKey(), gResources, false, this.executor) : this.anyObjectProvisioningManager.provision(anyObject.getKey(), gResources, false, this.executor);
            for (PropagationStatus propagationStatus : statuses) {
                result.append(anyObject.getType().getKey()).append(' ').append(anyObject.getKey()).append('\t').append("Resource ").append(propagationStatus.getResource()).append('\t').append(propagationStatus.getStatus());
                if (StringUtils.isNotBlank((CharSequence)propagationStatus.getFailureReason())) {
                    result.append('\n').append(propagationStatus.getFailureReason()).append('\n');
                }
                result.append('\n');
            }
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return true;
    }
}

