/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.MemberState;

public class CurrentAssignmentBuilder {
    private final ConsumerGroupMember member;
    private int targetAssignmentEpoch;
    private Assignment targetAssignment;
    private BiFunction<Uuid, Integer, Integer> currentPartitionEpoch;
    private List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions;

    public CurrentAssignmentBuilder(ConsumerGroupMember member) {
        this.member = Objects.requireNonNull(member);
    }

    public CurrentAssignmentBuilder withTargetAssignment(int targetAssignmentEpoch, Assignment targetAssignment) {
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.targetAssignment = Objects.requireNonNull(targetAssignment);
        return this;
    }

    public CurrentAssignmentBuilder withCurrentPartitionEpoch(BiFunction<Uuid, Integer, Integer> currentPartitionEpoch) {
        this.currentPartitionEpoch = Objects.requireNonNull(currentPartitionEpoch);
        return this;
    }

    public CurrentAssignmentBuilder withOwnedTopicPartitions(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        this.ownedTopicPartitions = ownedTopicPartitions;
        return this;
    }

    public ConsumerGroupMember build() {
        switch (this.member.state()) {
            case STABLE: {
                if (this.member.memberEpoch() != this.targetAssignmentEpoch) {
                    return this.computeNextAssignment(this.member.memberEpoch(), this.member.assignedPartitions());
                }
                return this.member;
            }
            case UNREVOKED_PARTITIONS: {
                if (this.ownsRevokedPartitions(this.member.partitionsPendingRevocation())) {
                    return this.member;
                }
                return this.computeNextAssignment(this.member.memberEpoch() + 1, this.member.assignedPartitions());
            }
            case UNRELEASED_PARTITIONS: {
                return this.computeNextAssignment(this.member.memberEpoch(), this.member.assignedPartitions());
            }
            case UNKNOWN: {
                if (this.ownedTopicPartitions == null || !this.ownedTopicPartitions.isEmpty()) {
                    throw new FencedMemberEpochException("The consumer group member is in a unknown state. The member must abandon all its partitions and rejoin.");
                }
                return this.computeNextAssignment(this.targetAssignmentEpoch, this.member.assignedPartitions());
            }
        }
        return this.member;
    }

    private boolean ownsRevokedPartitions(Map<Uuid, Set<Integer>> assignment) {
        if (this.ownedTopicPartitions == null) {
            return true;
        }
        for (ConsumerGroupHeartbeatRequestData.TopicPartitions topicPartitions : this.ownedTopicPartitions) {
            Set partitionsPendingRevocation = assignment.getOrDefault(topicPartitions.topicId(), Collections.emptySet());
            for (Integer partitionId : topicPartitions.partitions()) {
                if (!partitionsPendingRevocation.contains(partitionId)) continue;
                return true;
            }
        }
        return false;
    }

    private ConsumerGroupMember computeNextAssignment(int memberEpoch, Map<Uuid, Set<Integer>> memberAssignedPartitions) {
        boolean hasUnreleasedPartitions = false;
        HashMap<Uuid, Set<Integer>> newAssignedPartitions = new HashMap<Uuid, Set<Integer>>();
        HashMap<Uuid, Set<Integer>> newPartitionsPendingRevocation = new HashMap<Uuid, Set<Integer>>();
        HashMap<Uuid, Set> newPartitionsPendingAssignment = new HashMap<Uuid, Set>();
        HashSet<Uuid> allTopicIds = new HashSet<Uuid>(this.targetAssignment.partitions().keySet());
        allTopicIds.addAll(memberAssignedPartitions.keySet());
        for (Uuid topicId2 : allTopicIds) {
            Set target = this.targetAssignment.partitions().getOrDefault(topicId2, Collections.emptySet());
            Set currentAssignedPartitions = memberAssignedPartitions.getOrDefault(topicId2, Collections.emptySet());
            HashSet assignedPartitions = new HashSet(currentAssignedPartitions);
            assignedPartitions.retainAll(target);
            HashSet partitionsPendingRevocation = new HashSet(currentAssignedPartitions);
            partitionsPendingRevocation.removeAll(assignedPartitions);
            HashSet partitionsPendingAssignment = new HashSet(target);
            partitionsPendingAssignment.removeAll(assignedPartitions);
            boolean bl = hasUnreleasedPartitions = partitionsPendingAssignment.removeIf(partitionId -> this.currentPartitionEpoch.apply(topicId2, (Integer)partitionId) != -1) || hasUnreleasedPartitions;
            if (!assignedPartitions.isEmpty()) {
                newAssignedPartitions.put(topicId2, assignedPartitions);
            }
            if (!partitionsPendingRevocation.isEmpty()) {
                newPartitionsPendingRevocation.put(topicId2, partitionsPendingRevocation);
            }
            if (partitionsPendingAssignment.isEmpty()) continue;
            newPartitionsPendingAssignment.put(topicId2, partitionsPendingAssignment);
        }
        if (!newPartitionsPendingRevocation.isEmpty() && this.ownsRevokedPartitions(newPartitionsPendingRevocation)) {
            return new ConsumerGroupMember.Builder(this.member).setState(MemberState.UNREVOKED_PARTITIONS).updateMemberEpoch(memberEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(newPartitionsPendingRevocation).build();
        }
        if (!newPartitionsPendingAssignment.isEmpty()) {
            newPartitionsPendingAssignment.forEach((topicId, partitions) -> newAssignedPartitions.computeIfAbsent((Uuid)topicId, __ -> new HashSet()).addAll(partitions));
            MemberState newState = hasUnreleasedPartitions ? MemberState.UNRELEASED_PARTITIONS : MemberState.STABLE;
            return new ConsumerGroupMember.Builder(this.member).setState(newState).updateMemberEpoch(this.targetAssignmentEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Collections.emptyMap()).build();
        }
        if (hasUnreleasedPartitions) {
            return new ConsumerGroupMember.Builder(this.member).setState(MemberState.UNRELEASED_PARTITIONS).updateMemberEpoch(this.targetAssignmentEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Collections.emptyMap()).build();
        }
        return new ConsumerGroupMember.Builder(this.member).setState(MemberState.STABLE).updateMemberEpoch(this.targetAssignmentEpoch).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Collections.emptyMap()).build();
    }
}

