/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.InParameterParser;
import org.flowable.bpmn.converter.child.ScriptTextParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ScriptTask;

public class ScriptTaskXMLConverter
extends BaseBpmnXMLConverter {
    protected static final List<ExtensionAttribute> defaultScriptTaskAttributes = Arrays.asList(new ExtensionAttribute("scriptFormat"), new ExtensionAttribute("resultVariable"), new ExtensionAttribute("resultVariableName"), new ExtensionAttribute("skipExpression"), new ExtensionAttribute("autoStoreVariables"), new ExtensionAttribute("doNotIncludeVariables"));
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public ScriptTaskXMLConverter() {
        ScriptTextParser scriptTextParser = new ScriptTextParser();
        this.childParserMap.put(scriptTextParser.getElementName(), scriptTextParser);
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ScriptTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "scriptTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String autoStoreVariables;
        String skipExpression;
        ScriptTask scriptTask = new ScriptTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)scriptTask, xtr);
        scriptTask.setScriptFormat(xtr.getAttributeValue(null, "scriptFormat"));
        scriptTask.setResultVariable(BpmnXMLUtil.getAttributeValue("resultVariable", xtr));
        if (StringUtils.isEmpty((CharSequence)scriptTask.getResultVariable())) {
            scriptTask.setResultVariable(BpmnXMLUtil.getAttributeValue("resultVariableName", xtr));
        }
        if (StringUtils.isNotEmpty((CharSequence)(skipExpression = BpmnXMLUtil.getAttributeValue("skipExpression", xtr)))) {
            scriptTask.setSkipExpression(skipExpression);
        }
        if (StringUtils.isNotEmpty((CharSequence)(autoStoreVariables = BpmnXMLUtil.getAttributeValue("autoStoreVariables", xtr)))) {
            scriptTask.setAutoStoreVariables(Boolean.valueOf(autoStoreVariables).booleanValue());
        }
        scriptTask.setDoNotIncludeVariables(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("doNotIncludeVariables", xtr)));
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)scriptTask, defaultElementAttributes, defaultActivityAttributes, defaultScriptTaskAttributes);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)scriptTask, this.childParserMap, model, xtr);
        return scriptTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        this.writeDefaultAttribute("scriptFormat", scriptTask.getScriptFormat(), xtw);
        this.writeQualifiedAttribute("resultVariable", scriptTask.getResultVariable(), xtw);
        this.writeQualifiedAttribute("skipExpression", scriptTask.getSkipExpression(), xtw);
        this.writeQualifiedAttribute("autoStoreVariables", String.valueOf(scriptTask.isAutoStoreVariables()), xtw);
        if (scriptTask.isDoNotIncludeVariables()) {
            this.writeQualifiedAttribute("doNotIncludeVariables", "true", xtw);
        }
        BpmnXMLUtil.writeCustomAttributes(scriptTask.getAttributes().values(), xtw, defaultElementAttributes, defaultActivityAttributes, defaultScriptTaskAttributes);
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        didWriteExtensionStartElement = super.writeExtensionChildElements(element, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("in", scriptTask.getInParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        if (StringUtils.isNotEmpty((CharSequence)scriptTask.getScript())) {
            xtw.writeStartElement("script");
            xtw.writeCData(scriptTask.getScript());
            xtw.writeEndElement();
        }
    }
}

