/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.function.Function;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.SessionKeySchema;

class WrappedSessionStoreIterator
implements KeyValueIterator<Windowed<Bytes>, byte[]> {
    private final KeyValueIterator<Bytes, byte[]> bytesIterator;
    private final Function<Bytes, Windowed<Bytes>> windowConstructor;

    WrappedSessionStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator) {
        this(bytesIterator, SessionKeySchema::from);
    }

    WrappedSessionStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, Function<Bytes, Windowed<Bytes>> windowConstructor) {
        this.bytesIterator = bytesIterator;
        this.windowConstructor = windowConstructor;
    }

    @Override
    public void close() {
        this.bytesIterator.close();
    }

    @Override
    public Windowed<Bytes> peekNextKey() {
        return this.windowConstructor.apply(this.bytesIterator.peekNextKey());
    }

    @Override
    public boolean hasNext() {
        return this.bytesIterator.hasNext();
    }

    @Override
    public KeyValue<Windowed<Bytes>, byte[]> next() {
        KeyValue next = (KeyValue)this.bytesIterator.next();
        return KeyValue.pair(this.windowConstructor.apply((Bytes)next.key), next.value);
    }
}

