/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions.storage;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.BrowserStorage;
import org.apereo.cas.web.DefaultBrowserStorage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.actions.storage.BaseBrowserStorageAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ReadBrowserStorageAction
extends BaseBrowserStorageAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadBrowserStorageAction.class);
    public static final String BROWSER_STORAGE_REQUEST_IN_PROGRESS = "BrowserStorageReadRequest";

    public ReadBrowserStorageAction(CasCookieBuilder ticketGrantingCookieBuilder) {
        super(ticketGrantingCookieBuilder);
    }

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        DefaultBrowserStorage browserStorage = new DefaultBrowserStorage().setContext(WebUtils.getBrowserStorageContextKey((RequestContext)requestContext, (String)this.browserStorageContextKey)).setStorageType(this.determineStorageType(requestContext));
        Optional storageResult = WebUtils.getBrowserStoragePayload((RequestContext)requestContext);
        if (storageResult.isPresent()) {
            String storageData = (String)storageResult.get();
            browserStorage.setPayload(Objects.requireNonNull(storageData));
            this.hydrateWebflowFromStorage((BrowserStorage)browserStorage, requestContext);
            String targetState = WebUtils.getTargetState((RequestContext)requestContext);
            if (StringUtils.isBlank((CharSequence)targetState)) {
                WebUtils.putTargetState((RequestContext)requestContext, (String)"ticketGrantingTicketCheck");
            }
            requestContext.getFlowScope().remove(BROWSER_STORAGE_REQUEST_IN_PROGRESS);
            return this.result("success", "browserStorage", browserStorage);
        }
        if (requestContext.getFlowScope().contains(BROWSER_STORAGE_REQUEST_IN_PROGRESS)) {
            requestContext.getFlowScope().remove(BROWSER_STORAGE_REQUEST_IN_PROGRESS);
            return this.result("skip");
        }
        WebUtils.putBrowserStorage((RequestContext)requestContext, (BrowserStorage)browserStorage);
        requestContext.getFlowScope().put(BROWSER_STORAGE_REQUEST_IN_PROGRESS, (Object)Boolean.TRUE);
        return new EventFactorySupport().event((Object)this, "readFromBrowserStorage");
    }

    protected void hydrateWebflowFromStorage(BrowserStorage browserStorage, RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Map storageMap = browserStorage.getPayloadJson();
        if (storageMap != null && storageMap.containsKey(this.ticketGrantingCookieBuilder.getCookieName())) {
            String cookieValue = storageMap.get(this.ticketGrantingCookieBuilder.getCookieName()).toString();
            String ticketGrantingTicketId = this.ticketGrantingCookieBuilder.getCasCookieValueManager().obtainCookieValue(cookieValue, request);
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)requestContext, (String)ticketGrantingTicketId);
        }
        WebUtils.putBrowserStorage((RequestContext)requestContext, (BrowserStorage)browserStorage);
    }
}

