/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistryCleaner;
import org.apereo.cas.ticket.registry.TicketRegistryQueryCriteria;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;

@Endpoint(id="ticketRegistry", defaultAccess=Access.NONE)
public class TicketRegistryEndpoint
extends BaseCasRestActuatorEndpoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketRegistryEndpoint.class);
    private final ObjectProvider<TicketRegistry> ticketRegistryProvider;
    private final ObjectProvider<TicketRegistryCleaner> ticketRegistryCleanerProvider;
    private final ObjectProvider<TicketRegistrySupport> ticketRegistrySupportProvider;
    private final ObjectProvider<TicketCatalog> ticketCatalogProvider;

    public TicketRegistryEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<TicketRegistry> ticketRegistryProvider, ObjectProvider<TicketRegistryCleaner> ticketRegistryCleanerProvider, ObjectProvider<TicketRegistrySupport> ticketRegistrySupportProvider, ObjectProvider<TicketCatalog> ticketCatalogProvider) {
        super(casProperties, applicationContext);
        this.ticketRegistryProvider = ticketRegistryProvider;
        this.ticketRegistrySupportProvider = ticketRegistrySupportProvider;
        this.ticketRegistryCleanerProvider = ticketRegistryCleanerProvider;
        this.ticketCatalogProvider = ticketCatalogProvider;
    }

    @GetMapping(path={"/ticketCatalog"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Report registered ticket definitions from the ticket catalog")
    public ResponseEntity ticketCatalog() {
        return ResponseEntity.ok(((TicketCatalog)this.ticketCatalogProvider.getObject()).findAll().parallelStream().toList());
    }

    @GetMapping(path={"/query"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Query the ticket registry. Querying capabilities vary and depend on the registry implementation.", parameters={@Parameter(name="type", required=false, description="The type of the ticket to process, i.e. TGT", in=ParameterIn.QUERY), @Parameter(name="id", required=false, description="The ticket id to query. Requires type to be specified.", in=ParameterIn.QUERY), @Parameter(name="decode", required=false, schema=@Schema(type="boolean"), description="Whether the registry should return objects in raw form or decode and transform and check each ticket", in=ParameterIn.QUERY), @Parameter(name="count", schema=@Schema(type="integer"), description="Limit the number of objects and tickets returned in the response", required=false, in=ParameterIn.QUERY)})
    public List<?> query(@Valid @ModelAttribute TicketRegistryQueryCriteria criteria) {
        return ((TicketRegistry)this.ticketRegistryProvider.getObject()).query(criteria);
    }

    @DeleteMapping(path={"/clean"}, produces={"application/json", "application/vnd.spring-boot.actuator.v2+json", "application/vnd.spring-boot.actuator.v3+json", "application/x-www-form-urlencoded", "application/vnd.cas.services+yaml"})
    @Operation(summary="Clean the ticket registry on demand particularly when the cleaner schedule is turned off and you wish to force a cleanup manually via your own scheduler")
    public ResponseEntity clean() {
        ZonedDateTime startTime = ZonedDateTime.now(Clock.systemUTC());
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        long total = ((TicketRegistry)this.ticketRegistryProvider.getObject()).countTickets();
        int removed = ((TicketRegistryCleaner)this.ticketRegistryCleanerProvider.getObject()).clean();
        stopwatch.stop();
        ZonedDateTime endTime = ZonedDateTime.now(Clock.systemUTC());
        long duration = stopwatch.getTime(TimeUnit.SECONDS);
        Map<String, Long> payload = Map.of("total", total, "removed", removed, "startTime", startTime, "endTime", endTime, "duration", duration);
        LOGGER.debug("Ticket registry cleaner finished with the following payload: [{}]", payload);
        return ResponseEntity.ok(payload);
    }

    @Generated
    public ObjectProvider<TicketRegistry> getTicketRegistryProvider() {
        return this.ticketRegistryProvider;
    }

    @Generated
    public ObjectProvider<TicketRegistryCleaner> getTicketRegistryCleanerProvider() {
        return this.ticketRegistryCleanerProvider;
    }

    @Generated
    public ObjectProvider<TicketRegistrySupport> getTicketRegistrySupportProvider() {
        return this.ticketRegistrySupportProvider;
    }

    @Generated
    public ObjectProvider<TicketCatalog> getTicketCatalogProvider() {
        return this.ticketCatalogProvider;
    }
}

