/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.tracking;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.AllServicesSessionTrackingPolicy;
import org.jooq.lambda.Unchecked;

public class MostRecentServiceSessionTrackingPolicy
extends AllServicesSessionTrackingPolicy {
    public MostRecentServiceSessionTrackingPolicy(TicketRegistry ticketRegistry) {
        super(ticketRegistry);
    }

    @Override
    protected void beforeTrackingServiceTicket(Ticket ownerTicket, ServiceTicket serviceTicket) {
        TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ownerTicket;
        String path = MostRecentServiceSessionTrackingPolicy.normalizePath(serviceTicket.getService());
        List<Map.Entry> toRemove = ticketGrantingTicket.getServices().entrySet().stream().filter(entry -> {
            String normalizedExistingPath = MostRecentServiceSessionTrackingPolicy.normalizePath((Service)entry.getValue());
            return path.equals(normalizedExistingPath);
        }).toList();
        toRemove.forEach(Unchecked.consumer(entry -> {
            ticketGrantingTicket.getServices().remove(entry.getKey());
            this.ticketRegistry.deleteTicket((String)entry.getKey());
        }));
    }

    private static String normalizePath(Service service) {
        String path = service.getId();
        path = StringUtils.substringBefore((String)path, (String)"?");
        path = StringUtils.substringBefore((String)path, (String)";");
        path = StringUtils.substringBefore((String)path, (String)"#");
        return path;
    }
}

