/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.decorators.strategies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.SortingStrategy;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.IModelExtensions;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;

public class GroupingStrategy
implements SortingStrategy {
    private static int findMatchingType(IModel iModel) {
        ITemplateEvent iTemplateEvent = IModelExtensions.first(iModel);
        if (iTemplateEvent instanceof IComment) {
            return 1;
        }
        if (iTemplateEvent instanceof IProcessableElementTag) {
            IProcessableElementTag iProcessableElementTag = (IProcessableElementTag)iTemplateEvent;
            String string = iProcessableElementTag.getElementCompleteName();
            if (string.equals("meta")) {
                return 2;
            }
            if (string.equals("link")) {
                if ("stylesheet".equals(iProcessableElementTag.getAttributeValue("rel"))) {
                    return 5;
                }
            } else if (iTemplateEvent instanceof IOpenElementTag) {
                switch (string) {
                    case "script": {
                        return 3;
                    }
                    case "style": {
                        return 4;
                    }
                    case "title": {
                        return 6;
                    }
                }
            }
            return 7;
        }
        return iTemplateEvent instanceof IElementTag ? 7 : 0;
    }

    @Override
    public int findPositionForModel(IModel iModel, IModel iModel2) {
        int n;
        if (IModelExtensions.isWhitespace(iModel2)) {
            return -1;
        }
        int n2 = GroupingStrategy.findMatchingType(iModel2);
        ArrayList<IModel> arrayList = new ArrayList<IModel>(20);
        Iterator<IModel> iterator = IModelExtensions.childModelIterator(iModel);
        if (iterator != null) {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            IModel iModel3 = (IModel)listIterator.previous();
            if (n2 != GroupingStrategy.findMatchingType(iModel3)) continue;
            if (!IModelExtensions.asBoolean(iModel)) break;
            return IModelExtensions.findIndexOfModel(iModel, iModel3) + iModel3.size();
        }
        return n - ((n = iModel.size()) > 2 ? 2 : 1);
    }
}

