/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.models.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.ChildModelIterator;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.EventIterator;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.ITemplateEventExtensions;
import org.thymeleaf.model.ICloseElementTag;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IOpenElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.model.IText;

public class IModelExtensions {
    public static boolean asBoolean(@Nullable IModel iModel) {
        return iModel != null && iModel.size() > 0;
    }

    @Nullable
    public static Iterator<IModel> childModelIterator(@Nonnull IModel iModel) {
        return IModelExtensions.isElement(iModel) ? new ChildModelIterator(iModel) : null;
    }

    public static void each(@Nullable IModel iModel, @Nonnull Consumer<ITemplateEvent> consumer) {
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            consumer.accept(iterator.next());
        }
    }

    public static boolean equals(IModel iModel, Object object) {
        if (iModel != null && object instanceof IModel) {
            IModel iModel2 = (IModel)object;
            if (iModel.size() == iModel2.size()) {
                return IModelExtensions.everyWithIndex(iModel, (iTemplateEvent, n) -> ITemplateEventExtensions.equals(iTemplateEvent, iModel2.get(n.intValue())));
            }
        }
        return false;
    }

    public static boolean everyWithIndex(@Nullable IModel iModel, @Nonnull BiPredicate<ITemplateEvent, Integer> biPredicate) {
        int n = 0;
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            if (!biPredicate.test(iterator.next(), n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Nullable
    public static ITemplateEvent find(@Nullable IModel iModel, @Nonnull Predicate<ITemplateEvent> predicate) {
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            ITemplateEvent iTemplateEvent = iterator.next();
            if (!predicate.test(iTemplateEvent)) continue;
            return iTemplateEvent;
        }
        return null;
    }

    @Nonnull
    public static List<ITemplateEvent> findAll(@Nullable IModel iModel, @Nonnull Predicate<ITemplateEvent> predicate) {
        ArrayList<ITemplateEvent> arrayList = new ArrayList<ITemplateEvent>();
        Iterator<ITemplateEvent> iterator = IModelExtensions.maskNull(iModel);
        while (iterator.hasNext()) {
            ITemplateEvent iTemplateEvent = iterator.next();
            if (!predicate.test(iTemplateEvent)) continue;
            arrayList.add(iTemplateEvent);
        }
        return arrayList;
    }

    public static int findIndexOf(@Nonnull IModel iModel, @Nonnull Predicate<ITemplateEvent> predicate) {
        int n = iModel.size();
        for (int i = 0; i < n; ++i) {
            ITemplateEvent iTemplateEvent = iModel.get(i);
            boolean bl = predicate.test(iTemplateEvent);
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public static int findIndexOfModel(@Nonnull IModel iModel, IModel iModel2) {
        ITemplateEvent iTemplateEvent = IModelExtensions.first(iModel2);
        return IModelExtensions.findIndexOf(iModel, iTemplateEvent2 -> ITemplateEventExtensions.equals(iTemplateEvent2, iTemplateEvent));
    }

    public static IModel findModel(@Nonnull IModel iModel, @Nonnull Predicate<ITemplateEvent> predicate) {
        return IModelExtensions.getModel(iModel, IModelExtensions.findIndexOf(iModel, predicate));
    }

    public static ITemplateEvent first(@Nonnull IModel iModel) {
        return iModel.get(0);
    }

    @Nullable
    public static IModel getModel(@Nonnull IModel iModel, int n) {
        if (0 <= n && n < iModel.size()) {
            IModel iModel2 = iModel.getConfiguration().getModelFactory(iModel.getTemplateMode()).createModel();
            int n2 = IModelExtensions.sizeOfModelAt(iModel, n);
            while (n2-- > 0) {
                iModel2.add(iModel.get(n));
                ++n;
            }
            return iModel2;
        }
        return null;
    }

    public static void insertModelWithWhitespace(@Nonnull IModel iModel, int n, @Nullable IModel iModel2, @Nonnull IModelFactory iModelFactory) {
        if (0 <= n && n <= iModel.size()) {
            String string = "\t";
            if (n > 0) {
                for (int i = n - 1; i >= 0; --i) {
                    ITemplateEvent iTemplateEvent = iModel.get(i);
                    if (!ITemplateEventExtensions.isWhitespace(iTemplateEvent) || ((IText)iTemplateEvent).getText().isEmpty()) continue;
                    string = ((IText)iTemplateEvent).getText().replaceAll("[\r\n]", "");
                    break;
                }
            }
            if (n > 0 && iModel.get(n - 1) instanceof IOpenElementTag && iModel.get(n) instanceof ICloseElementTag) {
                iModel.insertModel(n, iModelFactory.createModel((ITemplateEvent)iModelFactory.createText((CharSequence)System.lineSeparator())));
            }
            iModel.insertModel(n, iModel2);
            iModel.insertModel(n, iModelFactory.createModel((ITemplateEvent)iModelFactory.createText((CharSequence)(System.lineSeparator() + string))));
        }
    }

    public static void insertWithWhitespace(@Nonnull IModel iModel, int n, @Nullable ITemplateEvent iTemplateEvent, @Nonnull IModelFactory iModelFactory) {
        if (0 <= n && n <= iModel.size()) {
            IModel iModel2 = IModelExtensions.getModel(iModel, n);
            if (IModelExtensions.asBoolean(iModel2) && IModelExtensions.isWhitespace(iModel2)) {
                iModel.insert(n, iTemplateEvent);
                iModel.insertModel(n, iModel2);
            } else {
                IText iText = iModelFactory.createText((CharSequence)"\n");
                if (n == 0) {
                    iModel.insert(n, (ITemplateEvent)iText);
                    iModel.insert(n, iTemplateEvent);
                } else if (n == iModel.size()) {
                    iModel.insert(n, (ITemplateEvent)iText);
                    iModel.insert(n, iTemplateEvent);
                    iModel.insert(n, (ITemplateEvent)iText);
                }
            }
        }
    }

    public static boolean isElement(@Nonnull IModel iModel) {
        return IModelExtensions.sizeOfModelAt(iModel, 0) == iModel.size();
    }

    public static boolean isWhitespace(@Nonnull IModel iModel) {
        return iModel.size() == 1 && ITemplateEventExtensions.isWhitespace(IModelExtensions.first(iModel));
    }

    @Nonnull
    public static Iterator<ITemplateEvent> iterator(@Nonnull IModel iModel) {
        return new EventIterator(iModel);
    }

    private static Iterator<ITemplateEvent> maskNull(@Nullable IModel iModel) {
        Iterator<ITemplateEvent> iterator = iModel != null ? IModelExtensions.iterator(iModel) : null;
        return iterator != null ? iterator : Collections.emptyIterator();
    }

    public static ITemplateEvent last(@Nonnull IModel iModel) {
        return iModel.get(iModel.size() - 1);
    }

    public static void removeAllModels(@Nonnull IModel iModel, Predicate<ITemplateEvent> predicate) {
        int n;
        while ((n = IModelExtensions.findIndexOf(iModel, predicate)) != -1) {
            IModelExtensions.removeModel(iModel, n);
        }
        return;
    }

    public static void removeChildren(@Nonnull IModel iModel) {
        if (IModelExtensions.isElement(iModel)) {
            while (iModel.size() > 2) {
                iModel.remove(1);
            }
        }
    }

    public static void removeFirst(@Nonnull IModel iModel) {
        iModel.remove(0);
    }

    public static void removeLast(@Nonnull IModel iModel) {
        iModel.remove(iModel.size() - 1);
    }

    public static void removeModel(@Nonnull IModel iModel, int n) {
        if (0 <= n && n < iModel.size()) {
            for (int i = IModelExtensions.sizeOfModelAt(iModel, n); i > 0; --i) {
                iModel.remove(n);
            }
        }
    }

    public static void replaceModel(@Nonnull IModel iModel, int n, @Nullable IModel iModel2) {
        if (0 <= n && n < iModel.size()) {
            IModelExtensions.removeModel(iModel, n);
            iModel.insertModel(n, iModel2);
        }
    }

    public static int sizeOfModelAt(@Nonnull IModel iModel, int n) {
        ITemplateEvent iTemplateEvent;
        int n2 = n;
        if ((iTemplateEvent = iModel.get(n2++)) instanceof IOpenElementTag) {
            int n3 = 0;
            while (true) {
                if ((iTemplateEvent = iModel.get(n2++)) instanceof IOpenElementTag) {
                    ++n3;
                    continue;
                }
                if (!(iTemplateEvent instanceof ICloseElementTag) || ((ICloseElementTag)iTemplateEvent).isUnmatched()) continue;
                if (n3 == 0) break;
                --n3;
            }
            return n2 - n;
        }
        return 1;
    }

    public static void trim(@Nonnull IModel iModel) {
        while (ITemplateEventExtensions.isWhitespace(IModelExtensions.first(iModel))) {
            IModelExtensions.removeFirst(iModel);
        }
        while (ITemplateEventExtensions.isWhitespace(IModelExtensions.last(iModel))) {
            IModelExtensions.removeLast(iModel);
        }
    }
}

