/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.events;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class SelectedEventsPanel
extends Panel {
    private static final long serialVersionUID = -4832450230348213500L;
    private final WebMarkupContainer selectionContainer;
    private final IModel<List<String>> model;

    public SelectedEventsPanel(String id, IModel<List<String>> model) {
        super(id);
        this.model = model;
        this.selectionContainer = new WebMarkupContainer("selectionContainer");
        this.selectionContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.selectionContainer});
        ListMultipleChoice<String> selectedEvents = new ListMultipleChoice<String>("selectedEvents", (IModel)new ListModel(), model){
            private static final long serialVersionUID = 1226677544225737338L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.remove("size");
                tag.remove("multiple");
                tag.put("size", 5);
            }
        };
        selectedEvents.setMaxRows(5);
        selectedEvents.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
            private static final long serialVersionUID = -4288397951948436434L;

            public Object getDisplayValue(String object) {
                return object;
            }

            public String getIdValue(String object, int index) {
                return object;
            }

            public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                return id;
            }
        });
        selectedEvents.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (ListMultipleChoice)selectedEvents){
            private static final long serialVersionUID = -151291731388673682L;
            final /* synthetic */ ListMultipleChoice val$selectedEvents;
            {
                this.val$selectedEvents = listMultipleChoice;
                super(event);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                SelectedEventsPanel.this.send((IEventSink)SelectedEventsPanel.this.getPage(), Broadcast.BREADTH, new InspectSelectedEvent(target, this.val$selectedEvents.getModelValue()));
            }
        }});
        this.selectionContainer.add(new Component[]{selectedEvents});
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof EventSelectionChanged) {
            EventSelectionChanged eventSelectionChanged = (EventSelectionChanged)object;
            eventSelectionChanged.getToBeRemoved().forEach(toBeRemoved -> ((List)this.model.getObject()).remove(toBeRemoved.toString()));
            eventSelectionChanged.getToBeAdded().stream().filter(toBeAdded -> !((List)this.model.getObject()).contains(toBeAdded.toString())).forEach(toBeAdded -> ((List)this.model.getObject()).add(toBeAdded.toString()));
            Collections.sort((List)this.model.getObject());
            eventSelectionChanged.getTarget().add(new Component[]{this.selectionContainer});
        }
    }

    public static class EventSelectionChanged {
        private final AjaxRequestTarget target;
        private final Set<OpEvent> toBeRemoved;
        private final Set<OpEvent> toBeAdded;

        public EventSelectionChanged(AjaxRequestTarget target, Set<OpEvent> toBeAdded, Set<OpEvent> toBeRemoved) {
            this.target = target;
            this.toBeAdded = toBeAdded;
            this.toBeRemoved = toBeRemoved;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public Set<OpEvent> getToBeRemoved() {
            return this.toBeRemoved;
        }

        public Set<OpEvent> getToBeAdded() {
            return this.toBeAdded;
        }
    }

    public static class InspectSelectedEvent {
        private final AjaxRequestTarget target;
        private final String event;

        public InspectSelectedEvent(AjaxRequestTarget target, String event) {
            this.target = target;
            this.event = event;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getEvent() {
            return this.event;
        }
    }
}

