/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DashboardAccessTokensPanel;
import org.apache.syncope.client.console.panels.DashboardControlPanel;
import org.apache.syncope.client.console.panels.DashboardExtensionsPanel;
import org.apache.syncope.client.console.panels.DashboardOverviewPanel;
import org.apache.syncope.client.console.panels.DashboardSystemPanel;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class Dashboard
extends BasePage {
    private static final long serialVersionUID = -1100228004207271270L;

    public Dashboard(PageParameters parameters) {
        super(parameters);
        WebMarkupContainer content = new WebMarkupContainer("content");
        this.body.add(new Component[]{content.setOutputMarkupId(true)});
        content.add(new Component[]{new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList())});
    }

    private List<ITab> buildTabList() {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("overview")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new DashboardOverviewPanel(panelId);
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("accessTokens")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new DashboardAccessTokensPanel(panelId, Dashboard.this.getPageReference());
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("control")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new DashboardControlPanel(panelId, Dashboard.this.getPageReference());
            }
        });
        tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("system")){
            private static final long serialVersionUID = -6815067322125799251L;

            public Panel getPanel(String panelId) {
                return new DashboardSystemPanel(panelId);
            }
        });
        final List<Class<BaseExtWidget>> extWidgetClasses = SyncopeWebApplication.get().getLookup().getClasses(BaseExtWidget.class);
        if (!extWidgetClasses.isEmpty()) {
            tabs.add((ITab)new AbstractTab((IModel)new ResourceModel("extensions")){
                private static final long serialVersionUID = -6815067322125799251L;

                public Panel getPanel(String panelId) {
                    return new DashboardExtensionsPanel(panelId, extWidgetClasses, Dashboard.this.getPageReference());
                }
            });
        }
        return tabs;
    }
}

