/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.FIQLQueryTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.FIQLQuery;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.data.FIQLQueryDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class FIQLQueryLogic
extends AbstractTransactionalLogic<FIQLQueryTO> {
    protected final FIQLQueryDataBinder binder;
    protected final FIQLQueryDAO fiqlQueryDAO;
    protected final UserDAO userDAO;
    protected final SecurityProperties securityProperties;

    public FIQLQueryLogic(FIQLQueryDataBinder binder, FIQLQueryDAO fiqlQueryDAO, UserDAO userDAO, SecurityProperties securityProperties) {
        this.binder = binder;
        this.fiqlQueryDAO = fiqlQueryDAO;
        this.userDAO = userDAO;
        this.securityProperties = securityProperties;
    }

    protected boolean skip() {
        return this.securityProperties.getAdminUser().equals(AuthContextUtils.getUsername()) || this.securityProperties.getAnonymousUser().equals(AuthContextUtils.getUsername());
    }

    protected void securityChecks(String owner) {
        if (!AuthContextUtils.getUsername().equals(owner)) {
            throw new DelegatedAdministrationException("/", AnyTypeKind.USER.name(), owner);
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public FIQLQueryTO read(String key) {
        if (this.skip()) {
            throw new NotFoundException("FIQLQuery " + key);
        }
        FIQLQuery fiqlQuery = (FIQLQuery)this.fiqlQueryDAO.findById(key).orElseThrow(() -> new NotFoundException("FIQLQuery " + key));
        this.securityChecks(fiqlQuery.getOwner().getUsername());
        return this.binder.getFIQLQueryTO(fiqlQuery);
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<FIQLQueryTO> list(String target) {
        if (this.skip()) {
            return List.of();
        }
        return this.fiqlQueryDAO.findByOwner((User)this.userDAO.findByUsername(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("User " + AuthContextUtils.getUsername())), target).stream().map(arg_0 -> ((FIQLQueryDataBinder)this.binder).getFIQLQueryTO(arg_0)).toList();
    }

    @PreAuthorize(value="isAuthenticated()")
    public FIQLQueryTO create(FIQLQueryTO fiqlQueryTO) {
        if (this.skip()) {
            throw new NotFoundException("FIQLQuery " + fiqlQueryTO.getKey());
        }
        return this.binder.getFIQLQueryTO((FIQLQuery)this.fiqlQueryDAO.save((Entity)this.binder.create(fiqlQueryTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public FIQLQueryTO update(FIQLQueryTO fiqlQueryTO) {
        if (this.skip()) {
            throw new NotFoundException("FIQLQuery " + fiqlQueryTO.getKey());
        }
        FIQLQuery fiqlQuery = (FIQLQuery)this.fiqlQueryDAO.findById(fiqlQueryTO.getKey()).orElseThrow(() -> new NotFoundException("FIQLQuery " + fiqlQueryTO.getKey()));
        this.securityChecks(fiqlQuery.getOwner().getUsername());
        return this.binder.getFIQLQueryTO((FIQLQuery)this.fiqlQueryDAO.save((Entity)this.binder.update(fiqlQuery, fiqlQueryTO)));
    }

    @PreAuthorize(value="isAuthenticated()")
    public FIQLQueryTO delete(String key) {
        if (this.skip()) {
            throw new NotFoundException("FIQLQuery " + key);
        }
        FIQLQuery fiqlQuery = (FIQLQuery)this.fiqlQueryDAO.findById(key).orElseThrow(() -> new NotFoundException("FIQLQuery " + key));
        this.securityChecks(fiqlQuery.getOwner().getUsername());
        FIQLQueryTO deleted = this.binder.getFIQLQueryTO(fiqlQuery);
        this.fiqlQueryDAO.deleteById(key);
        return deleted;
    }

    @Override
    protected FIQLQueryTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof FIQLQueryTO)) continue;
                FIQLQueryTO fIQLQueryTO = (FIQLQueryTO)object;
                key = fIQLQueryTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getFIQLQueryTO((FIQLQuery)this.fiqlQueryDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

