/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.RealmCheck;

public class RealmValidator
extends AbstractValidator<RealmCheck, Realm> {
    public boolean isValid(Realm realm, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if ("/".equals(realm.getName())) {
            if (realm.getParent() != null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidRealm, "Root realm cannot have a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
        } else {
            if (realm.getParent() == null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidRealm, "A realm needs to reference a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
            if (!RealmDAO.NAME_PATTERN.matcher(realm.getName()).matches()) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidRealm, "Only alphanumeric chars allowed in realm name")).addPropertyNode("name").addConstraintViolation();
            }
        }
        if (realm.getAnyTypeClass() != null) {
            List allowedPlainSchemas = Optional.ofNullable(realm.getAnyTypeClass()).map(atc -> atc.getPlainSchemas().stream().map(Entity::getKey).toList()).orElseGet(() -> List.of());
            for (PlainAttr attr : realm.getPlainAttrs()) {
                String plainSchema = Optional.ofNullable(attr).map(PlainAttr::getSchema).orElse(null);
                if (plainSchema == null || allowedPlainSchemas.contains(plainSchema)) continue;
                isValid = false;
                context.buildConstraintViolationWithTemplate(RealmValidator.getTemplate(EntityViolationType.InvalidPlainAttr, plainSchema + " not allowed for this instance")).addPropertyNode("plainAttrs").addConstraintViolation();
            }
        }
        return isValid;
    }
}

